/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncContext
implements AsyncContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncContext.class);
    private final TraceRoot traceRoot;
    private final AsyncId asyncId;
    private final AsyncTraceContext asyncTraceContext;
    private final int asyncMethodApiId;

    public DefaultAsyncContext(AsyncTraceContext asyncTraceContext, TraceRoot traceRoot, AsyncId asyncId, int asyncMethodApiId) {
        this.asyncTraceContext = (AsyncTraceContext)Assert.requireNonNull((Object)asyncTraceContext, (String)"asyncTraceContext must not be null");
        this.traceRoot = (TraceRoot)Assert.requireNonNull((Object)traceRoot, (String)"traceRoot must not be null");
        this.asyncId = (AsyncId)Assert.requireNonNull((Object)asyncId, (String)"asyncId must not be null");
        this.asyncMethodApiId = asyncMethodApiId;
    }

    public TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public Trace continueAsyncTraceObject() {
        Reference<Trace> reference = this.asyncTraceContext.currentRawTraceObject();
        Trace nestedTrace = reference.get();
        if (nestedTrace != null) {
            if (nestedTrace.canSampled()) {
                return nestedTrace;
            }
            return null;
        }
        return this.newAsyncTrace(reference);
    }

    private Trace newAsyncTrace(Reference<Trace> reference) {
        TraceScope oldScope;
        LocalAsyncId localAsyncId = this.asyncId.nextLocalAsyncId();
        Trace asyncTrace = this.asyncTraceContext.newAsyncTraceObject(this.traceRoot, localAsyncId);
        this.bind(reference, asyncTrace);
        if (logger.isDebugEnabled()) {
            logger.debug("asyncTraceContext.continueAsyncTraceObject() AsyncTrace:{}", (Object)asyncTrace);
        }
        if ((oldScope = asyncTrace.addScope("##ASYNC_TRACE_SCOPE")) != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Duplicated async trace scope={}.", (Object)oldScope.getName());
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("start async trace scope");
        }
        SpanEventRecorder recorder = asyncTrace.currentSpanEventRecorder();
        recorder.recordServiceType(ServiceType.ASYNC);
        recorder.recordApiId(this.asyncMethodApiId);
        return asyncTrace;
    }

    private void bind(Reference<Trace> reference, Trace asyncTrace) {
        Assert.state((reference.get() == null ? 1 : 0) != 0, (String)"traceReference is  null");
        reference.set(asyncTrace);
    }

    public Trace currentAsyncTraceObject() {
        Reference<Trace> reference = this.asyncTraceContext.currentTraceObject();
        return reference.get();
    }

    public void close() {
        this.asyncTraceContext.removeTraceObject();
    }

    public String toString() {
        return "DefaultAsyncContext{traceRoot=" + this.traceRoot + ", asyncId=" + this.asyncId + '}';
    }
}

