/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformRequestListener;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.instrument.RequestHandle;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.ProfilerException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTransformService
implements DynamicTransformTrigger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Instrumentation instrumentation;
    private DynamicTransformRequestListener dynamicTransformRequestListener;

    public DynamicTransformService(Instrumentation instrumentation, DynamicTransformRequestListener listener) {
        Assert.requireNonNull((Object)instrumentation, (String)"instrumentation must not be null");
        Assert.requireNonNull((Object)listener, (String)"listener must not be null");
        this.instrumentation = instrumentation;
        this.dynamicTransformRequestListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retransform(Class<?> target, ClassFileTransformer transformer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("retransform request class:{}", (Object)target.getName());
        }
        this.assertClass(target);
        RequestHandle requestHandle = this.dynamicTransformRequestListener.onRetransformRequest(target, transformer);
        boolean success = false;
        try {
            this.triggerRetransform(target);
            success = true;
        }
        finally {
            if (!success) {
                requestHandle.cancel();
            }
        }
    }

    public void addClassFileTransformer(ClassLoader classLoader, String targetClassName, ClassFileTransformer transformer) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Add dynamic transform. classLoader={}, class={}", (Object)classLoader, (Object)targetClassName);
        }
        this.dynamicTransformRequestListener.onTransformRequest(classLoader, targetClassName, transformer);
    }

    private void assertClass(Class<?> target) {
        if (!this.instrumentation.isModifiableClass(target)) {
            throw new ProfilerException("Target class " + target + " is not modifiable");
        }
    }

    private void triggerRetransform(Class<?> target) {
        try {
            this.instrumentation.retransformClasses(target);
        }
        catch (UnmodifiableClassException e) {
            throw new ProfilerException(e);
        }
    }

    public void setTransformRequestEventListener(DynamicTransformRequestListener retransformEventListener) {
        if (retransformEventListener == null) {
            throw new NullPointerException("dynamicTransformRequestListener must not be null");
        }
        this.dynamicTransformRequestListener = retransformEventListener;
    }
}

