/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.common.util.TransactionId;
import java.nio.ByteBuffer;

public final class TransactionIdUtils {
    public static final String TRANSACTION_ID_DELIMITER = "^";
    public static final byte VERSION = 0;
    private static final byte VERSION_SIZE = 1;

    private TransactionIdUtils() {
    }

    public static String formatString(TransactionId transactionId) {
        return TransactionIdUtils.formatString(transactionId.getAgentId(), transactionId.getAgentStartTime(), transactionId.getTransactionSequence());
    }

    public static String formatString(String agentId, long agentStartTime, long transactionSequence) {
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(agentId);
        sb.append(TRANSACTION_ID_DELIMITER);
        sb.append(agentStartTime);
        sb.append(TRANSACTION_ID_DELIMITER);
        sb.append(transactionSequence);
        return sb.toString();
    }

    public static byte[] formatBytes(String agentId, long agentStartTime, long transactionSequence) {
        byte[] buffer = TransactionIdUtils.writeTransactionId(agentId, agentStartTime, transactionSequence);
        return buffer;
    }

    public static ByteBuffer formatByteBuffer(String agentId, long agentStartTime, long transactionSequence) {
        byte[] buffer = TransactionIdUtils.writeTransactionId(agentId, agentStartTime, transactionSequence);
        return ByteBuffer.wrap(buffer);
    }

    private static byte[] writeTransactionId(String agentId, long agentStartTime, long transactionSequence) {
        byte[] agentIdBytes = BytesUtils.toBytes(agentId);
        int agentIdLength = TransactionIdUtils.getLength(agentIdBytes);
        int zigZagAgentIdLength = BytesUtils.intToZigZag(agentIdLength);
        int agentIdPrefixSize = BytesUtils.computeVar32Size(zigZagAgentIdLength);
        int agentStartTimeSize = BytesUtils.computeVar64Size(agentStartTime);
        int transactionIdSequenceSize = BytesUtils.computeVar64Size(transactionSequence);
        int bufferSize = 1 + agentIdPrefixSize + ArrayUtils.getLength(agentIdBytes) + agentStartTimeSize + transactionIdSequenceSize;
        byte[] buffer = new byte[bufferSize];
        buffer[0] = 0;
        int offset = 1;
        offset = BytesUtils.writeVar32(zigZagAgentIdLength, buffer, offset);
        if (agentIdBytes != null) {
            offset = BytesUtils.writeBytes(buffer, offset, agentIdBytes);
        }
        offset = BytesUtils.writeVar64(agentStartTime, buffer, offset);
        BytesUtils.writeVar64(transactionSequence, buffer, offset);
        return buffer;
    }

    private static int getLength(byte[] bytes) {
        if (bytes == null) {
            return -1;
        }
        return bytes.length;
    }

    public static TransactionId parseTransactionId(byte[] transactionId) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId must not be null");
        }
        FixedBuffer buffer = new FixedBuffer(transactionId);
        byte version = buffer.readByte();
        if (version != 0) {
            throw new IllegalArgumentException("invalid Version");
        }
        String agentId = buffer.readPrefixedString();
        long agentStartTime = buffer.readVLong();
        long transactionSequence = buffer.readVLong();
        if (agentId == null) {
            return new TransactionId(agentStartTime, transactionSequence);
        }
        return new TransactionId(agentId, agentStartTime, transactionSequence);
    }

    public static TransactionId parseTransactionId(String transactionId) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId must not be null");
        }
        int agentIdIndex = TransactionIdUtils.nextIndex(transactionId, 0);
        if (agentIdIndex == -1) {
            throw new IllegalArgumentException("agentIndex not found:" + transactionId);
        }
        String agentId = transactionId.substring(0, agentIdIndex);
        int agentStartTimeIndex = TransactionIdUtils.nextIndex(transactionId, agentIdIndex + 1);
        if (agentStartTimeIndex == -1) {
            throw new IllegalArgumentException("agentStartTimeIndex not found:" + transactionId);
        }
        long agentStartTime = TransactionIdUtils.parseLong(transactionId, agentIdIndex + 1, agentStartTimeIndex);
        int transactionSequenceIndex = TransactionIdUtils.nextIndex(transactionId, agentStartTimeIndex + 1);
        if (transactionSequenceIndex == -1) {
            transactionSequenceIndex = transactionId.length();
        }
        long transactionSequence = TransactionIdUtils.parseLong(transactionId, agentStartTimeIndex + 1, transactionSequenceIndex);
        return new TransactionId(agentId, agentStartTime, transactionSequence);
    }

    private static int nextIndex(String transactionId, int fromIndex) {
        return transactionId.indexOf(TRANSACTION_ID_DELIMITER, fromIndex);
    }

    private static long parseLong(String transactionId, int beginIndex, int endIndex) {
        String longString = transactionId.substring(beginIndex, endIndex);
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parseLong Error. " + longString + " transactionId:" + transactionId);
        }
    }
}

