/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceTypeRegistry {
    private final IntHashMap<ServiceType> codeLookupTable;
    private final Map<String, ServiceType> nameLookupTable;
    private final Map<String, List<ServiceType>> descLookupTable;

    private ServiceTypeRegistry() {
        this.codeLookupTable = new IntHashMap();
        this.nameLookupTable = new HashMap<String, ServiceType>();
        this.descLookupTable = new HashMap<String, List<ServiceType>>();
    }

    private ServiceTypeRegistry(HashMap<Integer, ServiceType> buildMap) {
        if (buildMap == null) {
            throw new NullPointerException("codeLookupTable must not be null");
        }
        this.codeLookupTable = IntHashMapUtils.copy(buildMap);
        this.nameLookupTable = this.buildNameLookupTable(buildMap.values());
        this.descLookupTable = this.buildDescLookupTable(buildMap.values());
    }

    private Map<String, ServiceType> buildNameLookupTable(Collection<ServiceType> serviceTypes) {
        HashMap<String, ServiceType> copy = new HashMap<String, ServiceType>();
        for (ServiceType serviceType : serviceTypes) {
            ServiceType duplicated = copy.put(serviceType.getName(), serviceType);
            if (duplicated == null) continue;
            throw new IllegalStateException("duplicated ServiceType " + serviceType + " / " + duplicated);
        }
        return copy;
    }

    public ServiceType findServiceType(short code) {
        ServiceType serviceType = this.codeLookupTable.get(code);
        if (serviceType == null) {
            return ServiceType.UNDEFINED;
        }
        return serviceType;
    }

    public ServiceType findServiceTypeByName(String name) {
        ServiceType serviceType = this.nameLookupTable.get(name);
        if (serviceType == null) {
            return ServiceType.UNDEFINED;
        }
        return serviceType;
    }

    @Deprecated
    public List<ServiceType> findDesc(String desc) {
        if (desc == null) {
            throw new NullPointerException("desc must not be null");
        }
        return this.descLookupTable.get(desc);
    }

    private Map<String, List<ServiceType>> buildDescLookupTable(Collection<ServiceType> serviceTypes) {
        HashMap<String, List<ServiceType>> table = new HashMap<String, List<ServiceType>>();
        for (ServiceType serviceType : serviceTypes) {
            if (!serviceType.isRecordStatistics()) continue;
            ArrayList<ServiceType> serviceTypeList = (ArrayList<ServiceType>)table.get(serviceType.getDesc());
            if (serviceTypeList == null) {
                serviceTypeList = new ArrayList<ServiceType>();
                table.put(serviceType.getDesc(), serviceTypeList);
            }
            serviceTypeList.add(serviceType);
        }
        return ServiceTypeRegistry.unmodifiableMap(table);
    }

    private static Map<String, List<ServiceType>> unmodifiableMap(Map<String, List<ServiceType>> table) {
        HashMap<String, List<ServiceType>> copy = new HashMap<String, List<ServiceType>>(table.size());
        for (Map.Entry<String, List<ServiceType>> entry : table.entrySet()) {
            List<ServiceType> newValue = Collections.unmodifiableList(entry.getValue());
            copy.put(entry.getKey(), newValue);
        }
        return copy;
    }

    public static class Builder {
        private final HashMap<Integer, ServiceType> buildMap = new HashMap();

        public void addServiceType(ServiceType serviceType) {
            if (serviceType == null) {
                throw new NullPointerException("serviceType must not be null");
            }
            short code = serviceType.getCode();
            ServiceType exist = this.buildMap.put(Integer.valueOf(code), serviceType);
            if (exist != null) {
                throw new IllegalStateException("already exist. serviceType:" + serviceType + ", exist:" + exist);
            }
        }

        public ServiceTypeRegistry build() {
            return new ServiceTypeRegistry(this.buildMap);
        }
    }
}

