/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class KafkaConfig {
    static final String PRODUCER_ENABLE = "profiler.kafka.producer.enable";
    static final String CONSUMER_ENABLE = "profiler.kafka.consumer.enable";
    static final String CONSUMER_ENTRY_POINT = "profiler.kafka.consumer.entryPoint";
    static final String SPRING_CONSUMER_ENABLE = "profiler.springkafka.consumer.enable";
    private final boolean producerEnable;
    private final boolean consumerEnable;
    private final boolean springConsumerEnable;
    private final String kafkaEntryPoint;

    public KafkaConfig(ProfilerConfig config) {
        this.producerEnable = config.readBoolean(PRODUCER_ENABLE, false);
        this.consumerEnable = config.readBoolean(CONSUMER_ENABLE, false);
        this.springConsumerEnable = config.readBoolean(SPRING_CONSUMER_ENABLE, false);
        this.kafkaEntryPoint = config.readString(CONSUMER_ENTRY_POINT, "");
    }

    public boolean isProducerEnable() {
        return this.producerEnable;
    }

    public boolean isConsumerEnable() {
        return this.consumerEnable;
    }

    public boolean isSpringConsumerEnable() {
        return this.springConsumerEnable;
    }

    public String getKafkaEntryPoint() {
        return this.kafkaEntryPoint;
    }
}

