/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.common;

import com.navercorp.pinpoint.rpc.common.SocketStateChangeResult;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;

public class SocketState {
    private SocketStateCode beforeState = SocketStateCode.NONE;
    private SocketStateCode currentState = SocketStateCode.NONE;

    public synchronized SocketStateChangeResult to(SocketStateCode nextState) {
        boolean enable = this.currentState.canChangeState(nextState);
        if (enable) {
            this.beforeState = this.currentState;
            this.currentState = nextState;
            return new SocketStateChangeResult(true, this.beforeState, this.currentState, nextState);
        }
        return new SocketStateChangeResult(false, this.beforeState, this.currentState, nextState);
    }

    public SocketStateChangeResult toBeingConnect() {
        SocketStateCode nextState = SocketStateCode.BEING_CONNECT;
        return this.to(nextState);
    }

    public SocketStateChangeResult toConnected() {
        SocketStateCode nextState = SocketStateCode.CONNECTED;
        return this.to(nextState);
    }

    public SocketStateChangeResult toConnectFailed() {
        SocketStateCode nextState = SocketStateCode.CONNECT_FAILED;
        return this.to(nextState);
    }

    public SocketStateChangeResult toIgnore() {
        SocketStateCode nextState = SocketStateCode.IGNORE;
        return this.to(nextState);
    }

    public SocketStateChangeResult toRunWithoutHandshake() {
        SocketStateCode nextState = SocketStateCode.RUN_WITHOUT_HANDSHAKE;
        return this.to(nextState);
    }

    public SocketStateChangeResult toRunSimplex() {
        SocketStateCode nextState = SocketStateCode.RUN_SIMPLEX;
        return this.to(nextState);
    }

    public SocketStateChangeResult toRunDuplex() {
        SocketStateCode nextState = SocketStateCode.RUN_DUPLEX;
        return this.to(nextState);
    }

    public SocketStateChangeResult toBeingCloseByClient() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    public SocketStateChangeResult toClosedByClient() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_CLIENT;
        return this.to(nextState);
    }

    public SocketStateChangeResult toUnexpectedCloseByClient() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    public SocketStateChangeResult toBeingCloseByServer() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    public SocketStateChangeResult toClosedByServer() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_SERVER;
        return this.to(nextState);
    }

    public SocketStateChangeResult toUnexpectedCloseByServer() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    public SocketStateChangeResult toUnknownError() {
        SocketStateCode nextState = SocketStateCode.ERROR_UNKNOWN;
        return this.to(nextState);
    }

    public SocketStateChangeResult toSyncStateSessionError() {
        SocketStateCode nextState = SocketStateCode.ERROR_SYNC_STATE_SESSION;
        return this.to(nextState);
    }

    public synchronized SocketStateCode getCurrentState() {
        return this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SocketStateCode currentState;
        SocketStateCode beforeState;
        SocketState socketState = this;
        synchronized (socketState) {
            beforeState = this.beforeState;
            currentState = this.currentState;
        }
        StringBuilder toString = new StringBuilder();
        toString.append(this.getClass().getSimpleName());
        toString.append("(");
        toString.append((Object)beforeState);
        toString.append("->");
        toString.append((Object)currentState);
        toString.append(")");
        return toString.toString();
    }
}

