/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.server.PinpointServerAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassPreLoader {
    public static void preload() {
        try {
            ClassPreLoader.preload(65535);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void preload(int port) {
        PinpointServerAcceptor serverAcceptor = null;
        PinpointSocket client = null;
        PinpointClientFactory clientFactory = null;
        try {
            serverAcceptor = new PinpointServerAcceptor();
            serverAcceptor.bind("127.0.0.1", port);
            clientFactory = new DefaultPinpointClientFactory();
            client = clientFactory.connect("127.0.0.1", port);
            client.sendSync(new byte[0]);
        }
        catch (Exception ex) {
            System.err.print("preLoad error Caused:" + ex.getMessage());
            ex.printStackTrace();
            Logger logger = LoggerFactory.getLogger(ClassPreLoader.class);
            logger.warn("preLoad error Caused:{}", (Object)ex.getMessage(), (Object)ex);
            if (ex instanceof PinpointSocketException) {
                throw (PinpointSocketException)ex;
            }
            throw new PinpointSocketException(ex.getMessage(), ex);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (clientFactory != null) {
                try {
                    clientFactory.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (serverAcceptor != null) {
                try {
                    serverAcceptor.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

