/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4PluginConfig;
import java.security.ProtectionDomain;

public class HttpClient4Plugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        if (this.logger.isInfoEnabled()) {
            HttpClient4PluginConfig httpClient4PluginConfig = new HttpClient4PluginConfig(context.getConfig());
            this.logger.info("HttpClient4Plugin config:{}", (Object)httpClient4PluginConfig);
        }
        this.addHttpRequestExecutorClass();
        this.addDefaultHttpRequestRetryHandlerClass();
        this.logger.debug("Add HttpClient4(4.0 ~ 4.2");
        this.addAbstractHttpClient4Class();
        this.addAbstractPooledConnAdapterClass();
        this.addManagedClientConnectionImplClass();
        this.logger.debug("Add CloseableHttpClient4(4.3 ~ ");
        this.addCloseableHttpClientClass();
        this.addBasicHttpClientConnectionManagerClass();
        this.addPoolingHttpClientConnectionManagerClass();
        this.logger.debug("Add CloseableHttpAsyncClient4(4.0 ~ ");
        this.addClosableHttpAsyncClientClass();
        this.addDefaultClientExchangeHandlerImplClass();
        this.addBasicFutureClass();
    }

    private void addHttpRequestExecutorClass() {
        this.transformTemplate.transform("org.apache.http.protocol.HttpRequestExecutor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod doReceiveResponse;
                InstrumentMethod doSendRequest;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod execute = target.getDeclaredMethod("execute", new String[]{"org.apache.http.HttpRequest", "org.apache.http.HttpClientConnection", "org.apache.http.protocol.HttpContext"});
                if (execute != null) {
                    execute.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpRequestExecutorExecuteMethodInterceptor", "HttpClient4Scope", ExecutionPolicy.ALWAYS);
                }
                if ((doSendRequest = target.getDeclaredMethod("doSendRequest", new String[]{"org.apache.http.HttpRequest", "org.apache.http.HttpClientConnection", "org.apache.http.protocol.HttpContext"})) != null) {
                    doSendRequest.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpRequestExecutorDoSendRequestAndDoReceiveResponseMethodInterceptor", "HttpClient4Scope", ExecutionPolicy.ALWAYS);
                }
                if ((doReceiveResponse = target.getDeclaredMethod("doReceiveResponse", new String[]{"org.apache.http.HttpRequest", "org.apache.http.HttpClientConnection", "org.apache.http.protocol.HttpContext"})) != null) {
                    doReceiveResponse.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpRequestExecutorDoSendRequestAndDoReceiveResponseMethodInterceptor", "HttpClient4Scope", ExecutionPolicy.ALWAYS);
                }
                return target.toBytecode();
            }
        });
    }

    private void addAbstractHttpClient4Class() {
        this.transformTemplate.transform("org.apache.http.impl.client.AbstractHttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, false, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, false, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, true, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.client.ResponseHandler"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, true, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.client.ResponseHandler", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, false, new String[]{"org.apache.http.client.methods.HttpUriRequest"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, false, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, true, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.client.ResponseHandler"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, true, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.client.ResponseHandler", "org.apache.http.protocol.HttpContext"});
                return target.toBytecode();
            }
        });
    }

    private void addCloseableHttpClientClass() {
        this.transformTemplate.transform("org.apache.http.impl.client.CloseableHttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, false, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, false, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, true, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.client.ResponseHandler"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpRequestInterceptor(target, true, new String[]{"org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.client.ResponseHandler", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, false, new String[]{"org.apache.http.client.methods.HttpUriRequest"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, false, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, true, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.client.ResponseHandler"});
                HttpClient4Plugin.this.injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(target, true, new String[]{"org.apache.http.client.methods.HttpUriRequest", "org.apache.http.client.ResponseHandler", "org.apache.http.protocol.HttpContext"});
                return target.toBytecode();
            }
        });
    }

    private void injectHttpClientExecuteMethodWithHttpRequestInterceptor(InstrumentClass target, boolean isHasCallbackParam, String ... parameterTypeNames) throws InstrumentException {
        InstrumentMethod execute = target.getDeclaredMethod("execute", parameterTypeNames);
        if (execute != null) {
            execute.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpClientExecuteMethodWithHttpRequestInterceptor", VarArgs.va((Object[])new Object[]{isHasCallbackParam}), "HttpClient4Scope");
        }
    }

    private void injectHttpClientExecuteMethodWithHttpUriRequestInterceptor(InstrumentClass target, boolean isHasCallbackParam, String ... parameterTypeNames) throws InstrumentException {
        InstrumentMethod execute = target.getDeclaredMethod("execute", parameterTypeNames);
        if (execute != null) {
            execute.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpClientExecuteMethodWithHttpUriRequestInterceptor", VarArgs.va((Object[])new Object[]{isHasCallbackParam}), "HttpClient4Scope");
        }
    }

    private void addDefaultHttpRequestRetryHandlerClass() {
        this.transformTemplate.transform("org.apache.http.impl.client.DefaultHttpRequestRetryHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod retryRequest = target.getDeclaredMethod("retryRequest", new String[]{"java.io.IOException", "int", "org.apache.http.protocol.HttpContext"});
                if (retryRequest != null) {
                    retryRequest.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.DefaultHttpRequestRetryHandlerRetryRequestMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addAbstractPooledConnAdapterClass() {
        this.transformTemplate.transform("org.apache.http.impl.conn.AbstractPooledConnAdapter", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod open = target.getDeclaredMethod("open", new String[]{"org.apache.http.conn.routing.HttpRoute", "org.apache.http.protocol.HttpContext", "org.apache.http.params.HttpParams"});
                if (open != null) {
                    open.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.ManagedClientConnectionOpenMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addManagedClientConnectionImplClass() {
        this.transformTemplate.transform("org.apache.http.impl.conn.ManagedClientConnectionImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod open = target.getDeclaredMethod("open", new String[]{"org.apache.http.conn.routing.HttpRoute", "org.apache.http.protocol.HttpContext", "org.apache.http.params.HttpParams"});
                if (open != null) {
                    open.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.ManagedClientConnectionOpenMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addBasicHttpClientConnectionManagerClass() {
        this.transformTemplate.transform("org.apache.http.impl.conn.BasicHttpClientConnectionManager", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod connect = target.getDeclaredMethod("connect", new String[]{"org.apache.http.HttpClientConnection", "org.apache.http.conn.routing.HttpRoute", "int", "org.apache.http.protocol.HttpContext"});
                if (connect != null) {
                    connect.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpClientConnectionManagerConnectMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addPoolingHttpClientConnectionManagerClass() {
        this.transformTemplate.transform("org.apache.http.impl.conn.PoolingHttpClientConnectionManager", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod connect = target.getDeclaredMethod("connect", new String[]{"org.apache.http.HttpClientConnection", "org.apache.http.conn.routing.HttpRoute", "int", "org.apache.http.protocol.HttpContext"});
                if (connect != null) {
                    connect.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpClientConnectionManagerConnectMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addClosableHttpAsyncClientClass() {
        this.transformTemplate.transform("org.apache.http.impl.nio.client.CloseableHttpAsyncClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                this.injectHttpAsyncClientExecuteMethodInterceptor(target, "org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.protocol.HttpContext", "org.apache.http.concurrent.FutureCallback");
                this.injectHttpAsyncClientExecuteMethodInterceptor(target, "org.apache.http.HttpHost", "org.apache.http.HttpRequest", "org.apache.http.concurrent.FutureCallback");
                this.injectHttpAsyncClientExecuteMethodInterceptor(target, "org.apache.http.nio.protocol.HttpAsyncRequestProducer", "org.apache.http.nio.protocol.HttpAsyncResponseConsumer", "org.apache.http.concurrent.FutureCallback");
                this.injectHttpAsyncClientExecuteMethodInterceptor(target, "org.apache.http.client.methods.HttpUriRequest", "org.apache.http.concurrent.FutureCallback");
                this.injectHttpAsyncClientExecuteMethodInterceptor(target, "org.apache.http.client.methods.HttpUriRequest", "org.apache.http.protocol.HttpContext", "org.apache.http.concurrent.FutureCallback");
                return target.toBytecode();
            }

            private void injectHttpAsyncClientExecuteMethodInterceptor(InstrumentClass target, String ... parameterTypeNames) throws InstrumentException {
                InstrumentMethod execute = target.getDeclaredMethod("execute", parameterTypeNames);
                if (execute != null) {
                    execute.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.HttpAsyncClientExecuteMethodInterceptor", "HttpClient4Scope");
                }
            }
        });
    }

    private void addDefaultClientExchangeHandlerImplClass() {
        this.transformTemplate.transform("org.apache.http.impl.nio.client.DefaultClientExchangeHandlerImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient4.RequestProducerGetter", "requestProducer");
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient4.ResultFutureGetter", "resultFuture");
                InstrumentMethod start = target.getDeclaredMethod("start", new String[0]);
                if (start != null) {
                    start.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.DefaultClientExchangeHandlerImplStartMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addBasicFutureClass() {
        this.transformTemplate.transform("org.apache.http.concurrent.BasicFuture", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod cancel;
                InstrumentMethod failed;
                InstrumentMethod completed;
                InstrumentMethod get2;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                InstrumentMethod get = target.getDeclaredMethod("get", new String[0]);
                if (get != null) {
                    get.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.BasicFutureMethodInterceptor");
                }
                if ((get2 = target.getDeclaredMethod("get", new String[]{"long", "java.util.concurrent.TimeUnit"})) != null) {
                    get2.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.BasicFutureMethodInterceptor");
                }
                if ((completed = target.getDeclaredMethod("completed", new String[]{"java.lang.Object"})) != null) {
                    completed.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.BasicFutureMethodInterceptor");
                }
                if ((failed = target.getDeclaredMethod("failed", new String[]{"java.lang.Exception"})) != null) {
                    failed.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.BasicFutureMethodInterceptor");
                }
                if ((cancel = target.getDeclaredMethod("cancel", new String[]{"boolean"})) != null) {
                    cancel.addInterceptor("com.navercorp.pinpoint.plugin.httpclient4.interceptor.BasicFutureMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

