/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.beans;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTarget;
import com.navercorp.pinpoint.plugin.spring.beans.SpringBeansTargetScope;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SpringBeansConfig {
    public static final String SPRING_BEANS_MARK_ERROR = "profiler.spring.beans.mark.error";
    public static final String SPRING_BEANS_ANNOTATION = "profiler.spring.beans.annotation";
    public static final String SPRING_BEANS_CLASS_PATTERN = "profiler.spring.beans.class.pattern";
    public static final String SPRING_BEANS_NAME_PATTERN = "profiler.spring.beans.name.pattern";
    public static final String SPRING_BEANS_PREFIX = "profiler.spring.beans.";
    public static final String SPRING_BEANS_SCOPE_POSTFIX = ".scope";
    public static final String SPRING_BEANS_BASE_PACKAGES_POSTFIX = ".base-packages";
    public static final String SPRING_BEANS_ANNOTATION_POSTFIX = ".annotation";
    public static final String SPRING_BEANS_CLASS_PATTERN_POSTFIX = ".class.pattern";
    public static final String SPRING_BEANS_NAME_PATTERN_POSTFIX = ".name.pattern";
    private static final String PATTERN_REGEX = "profiler.spring.beans.[0-9]+(.scope|.base-packages|.name.pattern|.class.pattern|.annotation)";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Map<Integer, SpringBeansTarget> targets = new HashMap<Integer, SpringBeansTarget>();

    public SpringBeansConfig(ProfilerConfig config) {
        Map<Integer, SpringBeansTarget> result = this.addBackwardCompatibilityTarget(config);
        result.putAll(this.addTarget(config));
        for (Map.Entry<Integer, SpringBeansTarget> entry : result.entrySet()) {
            if (!entry.getValue().isValid()) continue;
            this.targets.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<Integer, SpringBeansTarget> addBackwardCompatibilityTarget(ProfilerConfig config) {
        String annotations;
        String classPatternRegexs;
        HashMap<Integer, SpringBeansTarget> result = new HashMap<Integer, SpringBeansTarget>();
        String namePatternRegexs = config.readString(SPRING_BEANS_NAME_PATTERN, null);
        if (StringUtils.hasLength((String)namePatternRegexs)) {
            SpringBeansTarget target = new SpringBeansTarget();
            target.setNamePatterns(namePatternRegexs);
            result.put(-1, target);
        }
        if (StringUtils.hasLength((String)(classPatternRegexs = config.readString(SPRING_BEANS_CLASS_PATTERN, null)))) {
            SpringBeansTarget target = new SpringBeansTarget();
            target.setClassPatterns(classPatternRegexs);
            result.put(-2, target);
        }
        if (StringUtils.hasLength((String)(annotations = config.readString(SPRING_BEANS_ANNOTATION, null)))) {
            SpringBeansTarget target = new SpringBeansTarget();
            target.setAnnotations(annotations);
            result.put(-3, target);
        }
        return result;
    }

    private Map<Integer, SpringBeansTarget> addTarget(ProfilerConfig config) {
        HashMap<Integer, SpringBeansTarget> result = new HashMap<Integer, SpringBeansTarget>();
        Map patterns = config.readPattern(PATTERN_REGEX);
        for (Map.Entry entry : patterns.entrySet()) {
            try {
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith(SPRING_BEANS_PREFIX)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Invalid key format of spring-beans config {}={}", (Object)key, entry.getValue());
                    continue;
                }
                int point = key.indexOf(46, SPRING_BEANS_PREFIX.length());
                if (point < 0) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Not found key number of spring-beans config {}={}", (Object)key, entry.getValue());
                    continue;
                }
                int number = Integer.parseInt(key.substring(SPRING_BEANS_PREFIX.length(), point));
                SpringBeansTarget target = (SpringBeansTarget)result.get(number);
                if (target == null) {
                    target = new SpringBeansTarget();
                    result.put(number, target);
                }
                if (key.endsWith(SPRING_BEANS_NAME_PATTERN_POSTFIX)) {
                    target.setNamePatterns((String)entry.getValue());
                    continue;
                }
                if (key.endsWith(SPRING_BEANS_CLASS_PATTERN_POSTFIX)) {
                    target.setClassPatterns((String)entry.getValue());
                    continue;
                }
                if (key.endsWith(SPRING_BEANS_ANNOTATION_POSTFIX)) {
                    target.setAnnotations((String)entry.getValue());
                    continue;
                }
                if (key.endsWith(SPRING_BEANS_SCOPE_POSTFIX)) {
                    target.setScope((String)entry.getValue());
                    continue;
                }
                if (key.endsWith(SPRING_BEANS_BASE_PACKAGES_POSTFIX)) {
                    target.setBasePackages((String)entry.getValue());
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Unknown key format of spring-beans config. {}={}", (Object)key, entry.getValue());
            }
            catch (Exception e) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Invalid spring-beans config. {}={}", entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public SpringBeansTarget getTarget(int number) {
        return this.targets.get(number);
    }

    public Collection<SpringBeansTarget> getTargets() {
        return this.targets.values();
    }

    public boolean hasTarget(SpringBeansTargetScope scope) {
        for (SpringBeansTarget target : this.targets.values()) {
            if (target.getScope() != scope) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("targets=").append(this.targets);
        sb.append('}');
        return sb.toString();
    }
}

