/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.thrift.io.FlinkHeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocolFactory;

public class FlinkHeaderTBaseSerializerFactory
implements SerializerFactory<FlinkHeaderTBaseSerializer> {
    private final TypeLocator<TBase<?, ?>> tBaseLocator;
    private final HeaderTBaseSerializerFactory headerTBaseSerializerFactory;

    public FlinkHeaderTBaseSerializerFactory(TypeLocator<TBase<?, ?>> flinkTBaseLocator) {
        if (flinkTBaseLocator == null) {
            throw new NullPointerException("flinkTBaseLocator must not be null.");
        }
        this.tBaseLocator = flinkTBaseLocator;
        this.headerTBaseSerializerFactory = new HeaderTBaseSerializerFactory(this.tBaseLocator);
    }

    @Override
    public FlinkHeaderTBaseSerializer createSerializer() {
        ResettableByteArrayOutputStream baos = this.headerTBaseSerializerFactory.createResettableByteArrayOutputStream();
        TProtocolFactory protocolFactory = this.headerTBaseSerializerFactory.getProtocolFactory();
        return new FlinkHeaderTBaseSerializer(baos, protocolFactory, this.tBaseLocator);
    }

    @Override
    public boolean isSupport(Object target) {
        if (target instanceof TBase) {
            return this.tBaseLocator.isSupport(target.getClass());
        }
        return false;
    }
}

