/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinpointProfilerPackageFilter
implements ClassNameFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean debug = this.logger.isDebugEnabled();
    private final List<String> packageList;

    public PinpointProfilerPackageFilter() {
        this(PinpointProfilerPackageFilter.getPinpointPackageList());
    }

    public PinpointProfilerPackageFilter(List<String> packageList) {
        if (packageList == null) {
            throw new NullPointerException("packageList must not be null");
        }
        this.packageList = new ArrayList<String>(packageList);
    }

    @Override
    public boolean accept(String className) {
        for (String packageName : this.packageList) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getPinpointPackageList() {
        ArrayList<String> pinpointPackageList = new ArrayList<String>();
        pinpointPackageList.add("com.navercorp.pinpoint.bootstrap");
        pinpointPackageList.add("com.navercorp.pinpoint.profiler");
        pinpointPackageList.add("com.navercorp.pinpoint.common");
        pinpointPackageList.add("com.navercorp.pinpoint.exception");
        pinpointPackageList.add("com.navercorp.pinpoint.test");
        return pinpointPackageList;
    }
}

