/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.okhttp.EndPointUtils;
import com.navercorp.pinpoint.plugin.okhttp.v2.UrlGetter;
import com.navercorp.pinpoint.plugin.okhttp.v2.interceptor.AbstractRequestBuilderBuildMethodInterceptor;
import java.net.URL;

public class RequestBuilderBuildMethodBackwardCompatibilityInterceptor
extends AbstractRequestBuilderBuildMethodInterceptor {
    public RequestBuilderBuildMethodBackwardCompatibilityInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        super(traceContext, methodDescriptor, interceptorScope);
    }

    @Override
    String toHost(Object target) {
        if (target instanceof UrlGetter) {
            URL url = ((UrlGetter)target)._$PINPOINT$_getUrl();
            return this.getDestinationId(url);
        }
        return null;
    }

    private String getDestinationId(URL httpUrl) {
        if (httpUrl == null || httpUrl.getHost() == null) {
            return "UnknownHttpClient";
        }
        int port = EndPointUtils.getPort(httpUrl.getPort(), httpUrl.getDefaultPort());
        return HostAndPort.toHostAndPortString((String)httpUrl.getHost(), (int)port);
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
    }
}

