/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jetty;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.jetty.JettyConfiguration;
import com.navercorp.pinpoint.plugin.jetty.JettyDetector;
import java.security.ProtectionDomain;

public class JettyPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JettyConfiguration config = new JettyConfiguration(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("Disabled JettyPlugin.");
            return;
        }
        this.logger.info("Enable JettyPlugin. version range=[8.0, 9.4], config={}", (Object)config);
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{new JettyDetector(config.getBootstrapMains())});
        this.requestAspect(config);
        this.addServerInterceptor();
    }

    private void requestAspect(final JettyConfiguration config) {
        this.transformTemplate.transform("org.eclipse.jetty.server.Request", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod startAsyncMethodEditor;
                InstrumentMethod startAsyncMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (config.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.jetty.aspect.RequestAspect");
                }
                if ((startAsyncMethod = target.getDeclaredMethod("startAsync", new String[0])) != null) {
                    startAsyncMethod.addInterceptor("com.navercorp.pinpoint.plugin.jetty.interceptor.RequestStartAsyncInterceptor");
                }
                if ((startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"})) != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.jetty.interceptor.RequestStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addServerInterceptor() {
        this.transformTemplate.transform("org.eclipse.jetty.server.Server", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod handleMethodEditorBuilder = target.getDeclaredMethod("handle", new String[]{"org.eclipse.jetty.server.HttpChannel"});
                if (handleMethodEditorBuilder != null) {
                    handleMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.jetty.interceptor.Jetty9xServerHandleInterceptor");
                    return target.toBytecode();
                }
                InstrumentMethod jetty80HandleMethodEditorBuilder = target.getDeclaredMethod("handle", new String[]{"org.eclipse.jetty.server.HttpConnection"});
                if (jetty80HandleMethodEditorBuilder != null) {
                    jetty80HandleMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.jetty.interceptor.Jetty80ServerHandleInterceptor");
                    return target.toBytecode();
                }
                InstrumentMethod jetty82HandleMethodEditorBuilder = target.getDeclaredMethod("handle", new String[]{"org.eclipse.jetty.server.AbstractHttpConnection"});
                if (jetty82HandleMethodEditorBuilder != null) {
                    jetty82HandleMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.jetty.interceptor.Jetty8xServerHandleInterceptor");
                    return target.toBytecode();
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

