/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import java.util.HashMap;
import java.util.Map;

public class SocketOption
implements Cloneable {
    private static final String CONNECT_TIMEOUT_MILLIS = "connectTimeoutMillis";
    static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private final int connectTimeout;
    private final boolean tcpNoDelay;
    private final boolean keepAlive;
    private final int sendBufferSize;
    private final int receiveBufferSize;
    private final int writeBufferHighWaterMark;
    private final int writeBufferLowWaterMark;

    private SocketOption(int connectTimeout, boolean tcpNoDelay, boolean keepAlive, int sendBufferSize, int receiveBufferSize, int writeBufferHighWaterMark, int writeBufferLowWaterMark) {
        this.connectTimeout = connectTimeout;
        this.tcpNoDelay = tcpNoDelay;
        this.keepAlive = keepAlive;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(CONNECT_TIMEOUT_MILLIS, this.connectTimeout);
        options.put("tcpNoDelay", this.tcpNoDelay);
        options.put("keepAlive", this.keepAlive);
        options.put("sendBufferSize", this.sendBufferSize);
        options.put("receiveBufferSize", this.receiveBufferSize);
        options.put("writeBufferHighWaterMark", this.writeBufferHighWaterMark);
        options.put("writeBufferLowWaterMark", this.writeBufferLowWaterMark);
        return options;
    }

    public static class Builder {
        private int connectTimeout = 5000;
        private boolean tcpNoDelay = true;
        private boolean keepAlive = true;
        private int sendBufferSize = 65536;
        private int receiveBufferSize = 65536;
        private int writeBufferHighWaterMark = ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(16L);
        private int writeBufferLowWaterMark = ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(8L);

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(int connectTimeout) {
            if (connectTimeout < 0) {
                throw new IllegalArgumentException("connectTimeout cannot be a negative number");
            }
            this.connectTimeout = connectTimeout;
        }

        public boolean isTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public void setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
        }

        public boolean isKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
        }

        public int getSendBufferSize() {
            return this.sendBufferSize;
        }

        public void setSendBufferSize(int sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
        }

        public int getReceiveBufferSize() {
            return this.receiveBufferSize;
        }

        public void setReceiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
        }

        public int getWriteBufferHighWaterMark() {
            return this.writeBufferHighWaterMark;
        }

        public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
            Assert.isTrue((writeBufferHighWaterMark > 0 ? 1 : 0) != 0, (String)"must be writeBufferHighWaterMark > 0");
            this.writeBufferHighWaterMark = writeBufferHighWaterMark;
        }

        public int getWriteBufferLowWaterMark() {
            return this.writeBufferLowWaterMark;
        }

        public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
            Assert.isTrue((writeBufferLowWaterMark > 0 ? 1 : 0) != 0, (String)"must be writeBufferLowWaterMark > 0");
            this.writeBufferLowWaterMark = writeBufferLowWaterMark;
        }

        public SocketOption build() {
            return new SocketOption(this.connectTimeout, this.tcpNoDelay, this.keepAlive, this.sendBufferSize, this.receiveBufferSize, this.writeBufferHighWaterMark, this.writeBufferLowWaterMark);
        }
    }
}

