/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.StreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.StreamChannelManager;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import org.jboss.netty.channel.Channel;

public class PinpointClientHandlerContext {
    private final Channel channel;
    private final StreamChannelManager streamChannelManager;

    public PinpointClientHandlerContext(Channel channel, StreamChannelManager streamChannelManager) {
        if (channel == null) {
            throw new NullPointerException("channel must not be null");
        }
        if (streamChannelManager == null) {
            throw new NullPointerException("streamChannelManager must not be null");
        }
        this.channel = channel;
        this.streamChannelManager = streamChannelManager;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener) {
        return this.openStream(payload, messageListener, null);
    }

    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener, StreamChannelStateChangeEventHandler<ClientStreamChannel> stateChangeListener) {
        return this.streamChannelManager.openStream(payload, messageListener, stateChangeListener);
    }

    public void handleStreamEvent(StreamPacket message) {
        this.streamChannelManager.messageReceived(message);
    }

    public void closeAllStreamChannel() {
        this.streamChannelManager.close();
    }

    public StreamChannelContext getStreamChannel(int streamChannelId) {
        return this.streamChannelManager.findStreamChannel(streamChannelId);
    }
}

