/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap;

import com.navercorp.pinpoint.bootstrap.BootLogger;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Properties;

public class ContainerResolver {
    public static final String CONTAINER_PROPERTY_KEY = "pinpoint.container";
    private final BootLogger logger = BootLogger.getLogger(ContainerResolver.class.getName());
    private final Properties properties;

    public ContainerResolver() {
        this(System.getProperties());
    }

    public ContainerResolver(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties must not be null");
        }
        this.properties = properties;
    }

    public boolean isContainer() {
        if (this.properties.containsKey(CONTAINER_PROPERTY_KEY)) {
            String value = this.properties.getProperty(CONTAINER_PROPERTY_KEY);
            if (StringUtils.isEmpty((String)value)) {
                this.logger.info("-Dpinpoint.container found.");
                return true;
            }
            boolean isContainer = Boolean.parseBoolean(value);
            this.logger.info("-Dpinpoint.container found : " + value + ", resolved to " + isContainer);
            return isContainer;
        }
        return false;
    }
}

