/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.thrift.io.DefaultTBaseLocator;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.PinpointByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;
import com.navercorp.pinpoint.thrift.io.UnsafeByteArrayOutputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public final class HeaderTBaseSerializerFactory
implements SerializerFactory<HeaderTBaseSerializer> {
    private static final boolean DEFAULT_SAFE_GUARANTEED = true;
    public static final int DEFAULT_STREAM_SIZE = 8192;
    public static final int DEFAULT_UDP_STREAM_MAX_SIZE = 65536;
    private static final boolean DEFAULT_AUTO_EXPAND = true;
    private static final TypeLocator<TBase<?, ?>> DEFAULT_TBASE_LOCATOR = DefaultTBaseLocator.getTypeLocator();
    private static final TProtocolFactory DEFAULT_PROTOCOL_FACTORY = new TCompactProtocol.Factory();
    public static final HeaderTBaseSerializerFactory DEFAULT_FACTORY = new HeaderTBaseSerializerFactory();
    private final boolean safetyGuaranteed;
    private final int outputStreamSize;
    private final boolean autoExpand;
    private final TProtocolFactory protocolFactory;
    private final TypeLocator<TBase<?, ?>> locator;

    public HeaderTBaseSerializerFactory() {
        this(true);
    }

    public HeaderTBaseSerializerFactory(boolean safetyGuaranteed) {
        this(safetyGuaranteed, 8192);
    }

    public HeaderTBaseSerializerFactory(TypeLocator<TBase<?, ?>> locator) {
        this(true, 8192, true, DEFAULT_PROTOCOL_FACTORY, locator);
    }

    public HeaderTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize) {
        this(safetyGuaranteed, outputStreamSize, true);
    }

    public HeaderTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize, boolean autoExpand) {
        this(safetyGuaranteed, outputStreamSize, autoExpand, DEFAULT_PROTOCOL_FACTORY, DEFAULT_TBASE_LOCATOR);
    }

    public HeaderTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize, TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this(safetyGuaranteed, outputStreamSize, true, protocolFactory, locator);
    }

    public HeaderTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize, boolean autoExpand, TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.safetyGuaranteed = safetyGuaranteed;
        this.outputStreamSize = outputStreamSize;
        this.autoExpand = autoExpand;
        this.protocolFactory = protocolFactory;
        this.locator = locator;
    }

    public boolean isSafetyGuaranteed() {
        return this.safetyGuaranteed;
    }

    public int getOutputStreamSize() {
        return this.outputStreamSize;
    }

    public TProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public TypeLocator<TBase<?, ?>> getLocator() {
        return this.locator;
    }

    @Override
    public HeaderTBaseSerializer createSerializer() {
        ResettableByteArrayOutputStream baos = this.createResettableByteArrayOutputStream();
        return new HeaderTBaseSerializer(baos, this.protocolFactory, this.locator);
    }

    public ResettableByteArrayOutputStream createResettableByteArrayOutputStream() {
        ResettableByteArrayOutputStream baos = null;
        baos = this.safetyGuaranteed ? new PinpointByteArrayOutputStream(this.outputStreamSize, this.autoExpand) : new UnsafeByteArrayOutputStream(this.outputStreamSize, this.autoExpand);
        return baos;
    }

    @Override
    public boolean isSupport(Object target) {
        if (target instanceof TBase) {
            return this.locator.isSupport(target.getClass());
        }
        return false;
    }
}

