/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.jboss.JbossConstants;
import com.navercorp.pinpoint.plugin.jboss.MethodInvocationHandlerMethodDescriptor;
import com.navercorp.pinpoint.plugin.jboss.util.JbossUtility;
import java.lang.reflect.Method;
import org.jboss.as.security.remoting.RemotingContext;
import org.jboss.remoting3.Connection;

public class MethodInvocationHandlerInterceptor
implements AroundInterceptor {
    public static final MethodInvocationHandlerMethodDescriptor METHOD_INVOCATION_HANDLER_API_TAG = new MethodInvocationHandlerMethodDescriptor();
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor methodDescriptor;
    private final TraceContext traceContext;

    public MethodInvocationHandlerInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = descriptor;
        traceContext.cacheApi((MethodDescriptor)METHOD_INVOCATION_HANDLER_API_TAG);
    }

    public void before(Object target, Object[] args) {
        block5: {
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            try {
                Trace trace = this.createTrace(target, args);
                if (trace == null) {
                    return;
                }
                if (!trace.canSampled()) {
                    return;
                }
                SpanEventRecorder recorder = trace.traceBlockBegin();
                recorder.recordServiceType(JbossConstants.JBOSS_METHOD);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    private Trace createTrace(Object target, Object[] args) {
        Method methodInvoked = (Method)args[2];
        StringBuilder methodNameBuilder = new StringBuilder();
        if (methodInvoked != null) {
            try {
                Class<?> declaringClass = methodInvoked.getDeclaringClass();
                if (declaringClass != null) {
                    methodNameBuilder.append(declaringClass.getCanonicalName());
                    methodNameBuilder.append('.');
                }
                methodNameBuilder.append(methodInvoked.getName());
            }
            catch (Exception exception) {
                this.logger.error("An error occurred while fetching method details", (Throwable)exception);
            }
        }
        Trace trace = this.traceContext.newTraceObject();
        Connection connection = RemotingContext.getConnection();
        String remoteAddress = JbossUtility.fetchRemoteAddress(connection);
        if (trace.canSampled()) {
            SpanRecorder recorder = trace.getSpanRecorder();
            this.recordRootSpan(recorder, methodNameBuilder.toString(), remoteAddress);
            if (this.isDebug) {
                this.logger.debug("Trace sampling is true, Recording trace. methodInvoked:{}, remoteAddress:{}", (Object)methodNameBuilder.toString(), (Object)remoteAddress);
            }
        } else if (this.isDebug) {
            this.logger.debug("Trace sampling is false, Skip recording trace. methodInvoked:{}, remoteAddress:{}", (Object)methodNameBuilder.toString(), (Object)remoteAddress);
        }
        return trace;
    }

    private void recordRootSpan(SpanRecorder recorder, String rpcName, String remoteAddress) {
        recorder.recordServiceType(JbossConstants.JBOSS);
        recorder.recordRpcName(rpcName);
        String serverHostName = System.getProperty("jboss.host.name", "");
        recorder.recordEndPoint(serverHostName);
        recorder.recordRemoteAddress(remoteAddress);
        recorder.recordApi((MethodDescriptor)METHOD_INVOCATION_HANDLER_API_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!trace.canSampled()) {
            this.traceContext.removeTraceObject();
            trace.close();
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
            trace.close();
            this.traceContext.removeTraceObject();
        }
    }
}

