/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.tools.network;

import com.navercorp.pinpoint.tools.network.NetworkChecker;
import com.navercorp.pinpoint.tools.utils.HostResolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;

public abstract class AbstractNetworkChecker
implements NetworkChecker {
    private static final String WHITE_SPACE = "    ";
    private static final String LINE_SEPARATOR = "\r\n";
    private final String testName;
    private final InetSocketAddress hostAddress;
    private final List<InetSocketAddress> ipAddressList;

    public AbstractNetworkChecker(String testName, InetSocketAddress hostAddress) throws UnknownHostException {
        this.testName = testName;
        this.hostAddress = hostAddress;
        this.ipAddressList = HostResolver.getIPList(hostAddress);
    }

    protected abstract boolean check(InetSocketAddress var1) throws IOException;

    protected abstract boolean check(InetSocketAddress var1, byte[] var2, byte[] var3) throws IOException;

    @Override
    public void check() throws IOException {
        StringBuilder report = new StringBuilder(32);
        String hostName = this.getHostName(this.hostAddress);
        report.append(this.testName).append(":// ").append(hostName).append(LINE_SEPARATOR);
        for (InetSocketAddress ipAddress : this.ipAddressList) {
            boolean check = this.check(ipAddress);
            report.append(this.createReport(ipAddress, check));
        }
        System.out.println(report.toString());
    }

    @Override
    public void check(byte[] requestData, byte[] expectedResponseData) throws IOException {
        StringBuilder report = new StringBuilder(32);
        String hostName = this.getHostName(this.hostAddress);
        report.append(this.testName).append(":// ").append(hostName).append(LINE_SEPARATOR);
        for (InetSocketAddress ipAddress : this.ipAddressList) {
            boolean check = this.check(ipAddress, requestData, expectedResponseData);
            report.append(this.createReport(ipAddress, check));
        }
        System.out.println(report.toString());
    }

    private String getHostName(InetSocketAddress hostAddress) {
        String hostName = hostAddress.getHostName();
        return hostName;
    }

    private String createReport(InetSocketAddress socketAddress, boolean check) {
        String ip = this.getIp(socketAddress, socketAddress.getHostName());
        int port = socketAddress.getPort();
        StringBuilder report = new StringBuilder();
        report.append(WHITE_SPACE).append("=> ").append(ip).append(":").append(port);
        report.append(" [").append(check ? "SUCCESS" : "FAIL").append("]").append(LINE_SEPARATOR);
        return report.toString();
    }

    protected String getIp(InetSocketAddress socketAddress, String defaultValue) {
        InetAddress address = socketAddress.getAddress();
        if (address != null) {
            return address.getHostAddress();
        }
        return defaultValue;
    }
}

