/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.header.ByteArrayHeaderReader;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.header.HeaderReader;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import com.navercorp.pinpoint.io.request.DefaultMessage;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.io.util.TypeLocator;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderTBaseDeserializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TProtocol protocol;
    private final TMemoryInputTransport trans = new TMemoryInputTransport();
    private final TypeLocator<TBase<?, ?>> locator;

    HeaderTBaseDeserializer(TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.protocol = protocolFactory.getProtocol(this.trans);
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<TBase<?, ?>> deserialize(byte[] bytes) throws TException {
        try {
            this.trans.reset(bytes, 0, bytes.length);
            Message<TBase<?, ?>> message = this.readInternal();
            return message;
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
    }

    private Message<TBase<?, ?>> readInternal() throws TException {
        HeaderReader reader = this.newHeaderReader();
        Header header = this.readHeader(reader);
        HeaderEntity headerEntity = this.readHeaderEntity(reader, header);
        this.skipHeaderOffset(reader);
        TBase<?, ?> base = this.locator.bodyLookup(header.getType());
        if (base == null) {
            throw new TException("base must not be null type:" + header.getType());
        }
        base.read(this.protocol);
        return new DefaultMessage(header, headerEntity, base);
    }

    private void skipHeaderOffset(HeaderReader reader) {
        this.trans.reset(this.trans.getBuffer(), reader.getOffset(), reader.getRemaining());
    }

    private HeaderReader newHeaderReader() {
        byte[] buffer = this.trans.getBuffer();
        int bufferPosition = this.trans.getBufferPosition();
        int bytesRemainingInBuffer = this.trans.getBytesRemainingInBuffer();
        return new ByteArrayHeaderReader(buffer, bufferPosition, bytesRemainingInBuffer);
    }

    private Header readHeader(HeaderReader reader) throws TException {
        try {
            return reader.readHeader();
        }
        catch (InvalidHeaderException e) {
            throw new TException("invalid header Caused by:" + e.getMessage(), e);
        }
    }

    private HeaderEntity readHeaderEntity(HeaderReader reader, Header header) throws TException {
        try {
            return reader.readHeaderEntity(header);
        }
        catch (InvalidHeaderException e) {
            throw new TException("invalid headerEntity Caused by:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message<TBase<?, ?>>> deserializeList(byte[] buffer) throws TException {
        ArrayList tBaseList = new ArrayList();
        try {
            this.trans.reset(buffer, 0, buffer.length);
            while (this.trans.getBytesRemainingInBuffer() > 0) {
                Message<TBase<?, ?>> tBase = this.readInternal();
                tBaseList.add(tBase);
            }
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
        return tBaseList;
    }
}

