/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class DefaultCookieRecorder<T>
implements CookieRecorder<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final HttpDumpConfig httpDumpConfig;
    private final CookieExtractor<T> cookieExtractor;

    public DefaultCookieRecorder(HttpDumpConfig httpDumpConfig, CookieExtractor<T> cookieExtractor) {
        this.httpDumpConfig = Assert.requireNonNull(httpDumpConfig, "httpDumpConfig must not be null");
        this.cookieExtractor = Assert.requireNonNull(cookieExtractor, "cookieExtractor must not be null");
    }

    @Override
    public void record(SpanEventRecorder recorder, T cookie, Throwable throwable) {
        if (DumpType.ALWAYS == this.httpDumpConfig.getCookieDumpType()) {
            this.recordCookie(recorder, cookie);
        } else if (DumpType.EXCEPTION == this.httpDumpConfig.getCookieDumpType() && InterceptorUtils.isThrowable(throwable)) {
            this.recordCookie(recorder, cookie);
        }
    }

    private void recordCookie(SpanEventRecorder recorder, T cookie) {
        String cookieValue;
        if (this.httpDumpConfig.getCookieSampler().isSampling() && (cookieValue = this.cookieExtractor.getCookie(cookie)) != null) {
            int cookieDumpSize = this.httpDumpConfig.getCookieDumpSize();
            String cookieString = StringUtils.abbreviate(cookieValue, cookieDumpSize);
            recorder.recordAttribute(AnnotationKey.HTTP_COOKIE, cookieString);
            if (this.isDebug) {
                this.logger.debug("Record cookie={}", (Object)cookieValue);
            }
        }
    }
}

