/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BindValueUtils;
import java.util.HashMap;
import java.util.Map;

public class PreparedStatementExecuteQueryInterceptor
implements AroundInterceptor {
    private static final int DEFAULT_BIND_VALUE_LENGTH = 1024;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;
    private final int maxSqlBindValueLength;

    public PreparedStatementExecuteQueryInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this(traceContext, descriptor, 1024);
    }

    public PreparedStatementExecuteQueryInterceptor(TraceContext traceContext, MethodDescriptor descriptor, int maxSqlBindValueLength) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.maxSqlBindValueLength = maxSqlBindValueLength;
    }

    @Override
    public void before(Object target, Object[] args) {
        block9: {
            Trace trace;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((trace = this.traceContext.currentTraceObject()) == null) {
                return;
            }
            SpanEventRecorder recorder = trace.traceBlockBegin();
            try {
                DatabaseInfo databaseInfo;
                DatabaseInfo databaseInfo2 = databaseInfo = target instanceof DatabaseInfoAccessor ? ((DatabaseInfoAccessor)target)._$PINPOINT$_getDatabaseInfo() : null;
                if (databaseInfo == null) {
                    databaseInfo = UnKnownDatabaseInfo.INSTANCE;
                }
                recorder.recordServiceType(databaseInfo.getExecuteQueryType());
                recorder.recordEndPoint(databaseInfo.getMultipleHost());
                recorder.recordDestinationId(databaseInfo.getDatabaseId());
                ParsingResult parsingResult = null;
                if (target instanceof ParsingResultAccessor) {
                    parsingResult = ((ParsingResultAccessor)target)._$PINPOINT$_getParsingResult();
                }
                Map<Integer, String> bindValue = null;
                if (target instanceof BindValueAccessor) {
                    bindValue = ((BindValueAccessor)target)._$PINPOINT$_getBindValue();
                }
                if (bindValue != null) {
                    String bindString = this.toBindVariable(bindValue);
                    recorder.recordSqlParsingResult(parsingResult, bindString);
                } else {
                    recorder.recordSqlParsingResult(parsingResult);
                }
                recorder.recordApi(this.descriptor);
                this.clean(target);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block9;
                this.logger.warn(e.getMessage(), e);
            }
        }
    }

    private void clean(Object target) {
        if (target instanceof BindValueAccessor) {
            ((BindValueAccessor)target)._$PINPOINT$_setBindValue(new HashMap<Integer, String>());
        }
    }

    private String toBindVariable(Map<Integer, String> bindValue) {
        return BindValueUtils.bindValueToString(bindValue, this.maxSqlBindValueLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

