/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.ExceptionHandler;
import com.navercorp.pinpoint.bootstrap.interceptor.StaticAroundInterceptor;

public class ExceptionHandleStaticAroundInterceptor
implements StaticAroundInterceptor {
    private final StaticAroundInterceptor delegate;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandleStaticAroundInterceptor(StaticAroundInterceptor delegate, ExceptionHandler exceptionHandler) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler must not be null");
        }
        this.delegate = delegate;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void before(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        try {
            this.delegate.before(target, className, methodName, parameterDescription, args);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }

    @Override
    public void after(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        try {
            this.delegate.after(target, className, methodName, parameterDescription, args, result, throwable);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }
}

