/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.log4j2;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.log4j2.Log4j2Config;
import java.security.ProtectionDomain;

public class Log4j2Plugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final String INTERCEPTOR_CLASS = "com.navercorp.pinpoint.plugin.log4j2.interceptor.LogEventFactoryInterceptor";
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        Log4j2Config config = new Log4j2Config(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Log4j2Plugin config:{}", (Object)config);
        }
        if (!config.isLog4j2LoggingTransactionInfo()) {
            this.logger.info("Log4j2 plugin is not executed because log4j2 transform enable config value is false.");
            return;
        }
        this.transformTemplate.transform("org.apache.logging.log4j.core.impl.DefaultLogEventFactory", (TransformCallback)new DefaultLogEventFactoryTransform());
        this.transformTemplate.transform("org.apache.logging.log4j.core.impl.ReusableLogEventFactory", (TransformCallback)new ReusableLogEventFactoryTransform());
        this.transformTemplate.transform("org.apache.logging.log4j.core.async.RingBufferLogEventTranslator", (TransformCallback)new RingBufferLogEventTranslatorTransform());
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    static abstract class LogEventFactoryTransform
    implements TransformCallback {
        private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

        LogEventFactoryTransform() {
        }

        boolean validateThreadContextMethod(Instrumentor instrumentor, ClassLoader loader) {
            InstrumentClass mdcClass = instrumentor.getInstrumentClass(loader, "org.apache.logging.log4j.ThreadContext", null);
            if (mdcClass == null) {
                this.logger.warn("Can not modify. Because org.apache.logging.log4j.ThreadContext does not exist.");
                return false;
            }
            if (!mdcClass.hasMethod("put", new String[]{"java.lang.String", "java.lang.String"})) {
                this.logger.warn("Can not modify. Because put method does not exist at org.apache.logging.log4j.ThreadContext class.");
                return false;
            }
            if (!mdcClass.hasMethod("remove", new String[]{"java.lang.String"})) {
                this.logger.warn("Can not modify. Because remove method does not exist at org.apache.logging.log4j.ThreadContext class.");
                return false;
            }
            return true;
        }
    }

    public static class RingBufferLogEventTranslatorTransform
    extends LogEventFactoryTransform {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            if (!this.validateThreadContextMethod(instrumentor, loader)) {
                return null;
            }
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            this.addInterceptor(target, "translateTo", new String[]{"org.apache.logging.log4j.core.async.RingBufferLogEvent", "long"}, Log4j2Plugin.INTERCEPTOR_CLASS);
            return target.toBytecode();
        }

        private void addInterceptor(InstrumentClass target, String methodName, String[] parameterTypes, String interceptorClassName) throws InstrumentException {
            InstrumentMethod method = target.getDeclaredMethod(methodName, parameterTypes);
            if (method != null) {
                method.addInterceptor(interceptorClassName);
            }
        }
    }

    public static class ReusableLogEventFactoryTransform
    extends LogEventFactoryTransform {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            if (!this.validateThreadContextMethod(instrumentor, loader)) {
                return null;
            }
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            this.addInterceptor(target, "createEvent", new String[]{"java.lang.String", "org.apache.logging.log4j.Marker", "java.lang.String", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.message.Message", "java.util.List", "java.lang.Throwable"}, Log4j2Plugin.INTERCEPTOR_CLASS);
            this.addInterceptor(target, "createEvent", new String[]{"java.lang.String", "org.apache.logging.log4j.Marker", "java.lang.String", "java.lang.StackTraceElement", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.message.Message", "java.util.List", "java.lang.Throwable"}, Log4j2Plugin.INTERCEPTOR_CLASS);
            return target.toBytecode();
        }

        private void addInterceptor(InstrumentClass target, String methodName, String[] parameterTypes, String interceptorClassName) throws InstrumentException {
            InstrumentMethod method = target.getDeclaredMethod(methodName, parameterTypes);
            if (method != null) {
                method.addScopedInterceptor(interceptorClassName, "reusableLogEventFactoryScope", ExecutionPolicy.BOUNDARY);
            }
        }
    }

    public static class DefaultLogEventFactoryTransform
    extends LogEventFactoryTransform {
        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            if (!this.validateThreadContextMethod(instrumentor, loader)) {
                return null;
            }
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            this.addInterceptor(target, "createEvent", new String[]{"java.lang.String", "org.apache.logging.log4j.Marker", "java.lang.String", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.message.Message", "java.util.List", "java.lang.Throwable"}, Log4j2Plugin.INTERCEPTOR_CLASS);
            this.addInterceptor(target, "createEvent", new String[]{"java.lang.String", "org.apache.logging.log4j.Marker", "java.lang.String", "java.lang.StackTraceElement", "org.apache.logging.log4j.Level", "org.apache.logging.log4j.message.Message", "java.util.List", "java.lang.Throwable"}, Log4j2Plugin.INTERCEPTOR_CLASS);
            return target.toBytecode();
        }

        private void addInterceptor(InstrumentClass target, String methodName, String[] parameterTypes, String interceptorClassName) throws InstrumentException {
            InstrumentMethod method = target.getDeclaredMethod(methodName, parameterTypes);
            if (method != null) {
                method.addInterceptor(interceptorClassName);
            }
        }
    }
}

