/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConstants;
import java.util.Arrays;

public class MySQLConnectionCreateInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;

    public MySQLConnectionCreateInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (args == null || args.length != 5) {
            return;
        }
        String hostToConnectTo = this.getString(args[0]);
        Integer portToConnectTo = this.getInteger(args[1]);
        String databaseId = this.getString(args[3]);
        DatabaseInfo databaseInfo = null;
        if (hostToConnectTo != null && portToConnectTo != null && databaseId != null) {
            databaseInfo = this.createDatabaseInfo(hostToConnectTo, portToConnectTo, databaseId);
            if (InterceptorUtils.isSuccess((Throwable)throwable) && target instanceof DatabaseInfoAccessor) {
                ((DatabaseInfoAccessor)target)._$PINPOINT$_setDatabaseInfo(databaseInfo);
            }
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.currentSpanEventRecorder();
        if (databaseInfo != null) {
            recorder.recordServiceType(databaseInfo.getType());
            recorder.recordEndPoint(databaseInfo.getMultipleHost());
            recorder.recordDestinationId(databaseInfo.getDatabaseId());
        }
    }

    private DatabaseInfo createDatabaseInfo(String url, Integer port, String databaseId) {
        if (url.indexOf(58) == -1) {
            url = url + ":" + port;
        }
        DefaultDatabaseInfo databaseInfo = new DefaultDatabaseInfo(MySqlConstants.MYSQL, MySqlConstants.MYSQL_EXECUTE_QUERY, url, url, Arrays.asList(url), databaseId);
        return databaseInfo;
    }

    private String getString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private Integer getInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    public void before(Object target, Object[] args) {
    }
}

