/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.plugin;

import com.navercorp.pinpoint.common.plugin.DirClassPathPlugin;
import com.navercorp.pinpoint.common.plugin.JarPlugin;
import com.navercorp.pinpoint.common.plugin.Plugin;
import com.navercorp.pinpoint.common.plugin.PluginLoader;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CodeSourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.JarFile;

public class ServerPluginLoader
implements PluginLoader {
    private final ClassLoader classLoader;

    public ServerPluginLoader(ClassLoader classLoader) {
        this.classLoader = Assert.requireNonNull(classLoader, "classLoader must not be null");
    }

    @Override
    public <T> List<Plugin<T>> load(Class<T> serviceType) {
        Assert.requireNonNull(serviceType, "serviceType must not be null");
        ArrayList<Plugin<T>> pluginList = new ArrayList<Plugin<T>>();
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType, this.classLoader);
        for (T plugin : serviceLoader) {
            Plugin<T> simple = this.newPlugin(plugin);
            pluginList.add(simple);
        }
        return pluginList;
    }

    private <T> Plugin<T> newPlugin(T plugin) {
        URL pluginURL = CodeSourceUtils.getCodeLocation(plugin.getClass());
        if (pluginURL == null) {
            throw new IllegalStateException("pluginURL not found plugin:" + plugin.getClass());
        }
        File file = new File(pluginURL.getFile());
        if (file.isDirectory()) {
            return new DirClassPathPlugin<T>(pluginURL, Collections.singletonList(plugin), Collections.<String>emptyList());
        }
        if (file.getName().endsWith(".jar")) {
            JarFile jarFile = this.toJarFile(file);
            return new JarPlugin<T>(pluginURL, jarFile, Collections.singletonList(plugin), Collections.<String>emptyList());
        }
        throw new IllegalArgumentException("unknown plugin " + pluginURL);
    }

    private JarFile toJarFile(File file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new RuntimeException("jarFile create fail " + e.getMessage(), e);
        }
    }
}

