/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.websphere;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.websphere.WebsphereConfiguration;
import com.navercorp.pinpoint.plugin.websphere.WebsphereDetector;
import java.security.ProtectionDomain;

public class WebspherePlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        WebsphereConfiguration config = new WebsphereConfiguration(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("WebspherePlugin disabled");
            return;
        }
        this.logger.info("WebspherePlugin config:{}", (Object)config);
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{new WebsphereDetector(config.getBootstrapMains())});
        this.addSRTServletRequest(config);
        this.addWSWebContainer();
        this.addWCCResponseImpl();
        this.addWSAsyncContextImpl();
    }

    private void addSRTServletRequest(final WebsphereConfiguration config) {
        this.transformTemplate.transform("com.ibm.ws.webcontainer.srt.SRTServletRequest", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod startAsyncMethodEditor;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (config.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.websphere.aspect.SRTServletRequestAspect");
                }
                if ((startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"})) != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.websphere.interceptor.WCCRequestImplStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addWSWebContainer() {
        this.transformTemplate.transform("com.ibm.ws.webcontainer.WSWebContainer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod handleMethodEditorBuilder = target.getDeclaredMethod("handleRequest", new String[]{"com.ibm.websphere.servlet.request.IRequest", "com.ibm.websphere.servlet.response.IResponse"});
                if (handleMethodEditorBuilder != null) {
                    handleMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.websphere.interceptor.WebContainerHandleRequestInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addWCCResponseImpl() {
        this.transformTemplate.transform("com.ibm.ws.webcontainer.channel.WCCResponseImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.websphere.StatusCodeAccessor");
                InstrumentMethod setStatusCodeMethod = target.getDeclaredMethod("setStatusCode", new String[]{"int"});
                if (setStatusCodeMethod != null) {
                    setStatusCodeMethod.addInterceptor("com.navercorp.pinpoint.plugin.websphere.interceptor.WCCResponseImplInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addWSAsyncContextImpl() {
        this.transformTemplate.transform("com.ibm.ws.webcontainer.async.WSAsyncContextImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.websphere.InitResponseGetter", "initResponse");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

