/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.httpclient3.HttpClient3PluginConfig;
import java.security.ProtectionDomain;

public class HttpClient3Plugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        HttpClient3PluginConfig config = new HttpClient3PluginConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("HttpClient3Plugin config:{}", (Object)config);
        }
        this.addHttpClient3Class();
        this.addDefaultHttpMethodRetryHandlerClass();
        this.addHttpConnectionClass();
        this.addHttpMethodBaseClass(config);
    }

    private void addHttpClient3Class() {
        this.transformTemplate.transform("org.apache.commons.httpclient.HttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumenttor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumenttor.getInstrumentClass(loader, className, classfileBuffer);
                this.injectHttpClientExecuteMethod(target, "org.apache.commons.httpclient.HttpMethod");
                this.injectHttpClientExecuteMethod(target, "org.apache.commons.httpclient.HostConfiguration", "org.apache.commons.httpclient.HttpMethod");
                this.injectHttpClientExecuteMethod(target, "org.apache.commons.httpclient.HostConfiguration", "org.apache.commons.httpclient.HttpMethod", "org.apache.commons.httpclient.HttpState");
                return target.toBytecode();
            }

            private void injectHttpClientExecuteMethod(InstrumentClass target, String ... parameterTypeNames) throws InstrumentException {
                InstrumentMethod method = target.getDeclaredMethod("executeMethod", parameterTypeNames);
                if (method != null) {
                    method.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.ExecuteInterceptor", "HttpClient3Scope");
                }
            }
        });
    }

    private void addDefaultHttpMethodRetryHandlerClass() {
        this.transformTemplate.transform("org.apache.commons.httpclient.DefaultHttpMethodRetryHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod retryMethod = target.getDeclaredMethod("retryMethod", new String[]{"org.apache.commons.httpclient.HttpMethod", "java.io.IOException", "int"});
                if (retryMethod != null) {
                    retryMethod.addInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.RetryMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpConnectionClass() {
        this.transformTemplate.transform("org.apache.commons.httpclient.HttpConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient3.HostNameGetter", "hostName");
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient3.PortNumberGetter", "portNumber");
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient3.ProxyHostNameGetter", "proxyHostName");
                target.addGetter("com.navercorp.pinpoint.plugin.httpclient3.ProxyPortNumberGetter", "proxyPortNumber");
                InstrumentMethod open = target.getDeclaredMethod("open", new String[0]);
                if (open != null) {
                    open.addInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.HttpConnectionOpenMethodInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addHttpMethodBaseClass(final HttpClient3PluginConfig config) {
        this.transformTemplate.transform("org.apache.commons.httpclient.HttpMethodBase", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod execute = target.getDeclaredMethod("execute", new String[]{"org.apache.commons.httpclient.HttpState", "org.apache.commons.httpclient.HttpConnection"});
                if (execute != null) {
                    execute.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.HttpMethodBaseExecuteMethodInterceptor", "HttpClient3MethodBase", ExecutionPolicy.ALWAYS);
                }
                if (config.isIo()) {
                    InstrumentMethod readResponse;
                    InstrumentMethod writeRequest = target.getDeclaredMethod("writeRequest", new String[]{"org.apache.commons.httpclient.HttpState", "org.apache.commons.httpclient.HttpConnection"});
                    if (writeRequest != null) {
                        writeRequest.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.HttpMethodBaseRequestAndResponseMethodInterceptor", "HttpClient3MethodBase", ExecutionPolicy.ALWAYS);
                    }
                    if ((readResponse = target.getDeclaredMethod("readResponse", new String[]{"org.apache.commons.httpclient.HttpState", "org.apache.commons.httpclient.HttpConnection"})) != null) {
                        readResponse.addScopedInterceptor("com.navercorp.pinpoint.plugin.httpclient3.interceptor.HttpMethodBaseRequestAndResponseMethodInterceptor", "HttpClient3MethodBase", ExecutionPolicy.ALWAYS);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

