/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientConstants;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientPluginConfig;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;

public class ChannelBasicPublishInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final MethodDescriptor descriptor;
    private final TraceContext traceContext;
    private final InterceptorScope scope;
    private final Filter<String> excludeExchangeFilter;

    public ChannelBasicPublishInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.descriptor = descriptor;
        this.traceContext = traceContext;
        this.scope = scope;
        RabbitMQClientPluginConfig rabbitMQClientPluginConfig = new RabbitMQClientPluginConfig(traceContext.getProfilerConfig());
        this.excludeExchangeFilter = rabbitMQClientPluginConfig.getExcludeExchangeFilter();
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            if (this.isDebug) {
                this.logger.debug("validate argument failed!");
            }
            return;
        }
        String exchange = (String)args[0];
        if (RabbitMQClientPluginConfig.isExchangeExcluded(exchange, this.excludeExchangeFilter)) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null) {
            return;
        }
        if (trace.canSampled()) {
            SpanEventRecorder recorder = trace.traceBlockBegin();
            recorder.recordServiceType(RabbitMQClientConstants.RABBITMQ_CLIENT);
            TraceId nextId = trace.getTraceId().getNextTraceId();
            recorder.recordNextSpanId(nextId.getSpanId());
            InterceptorScopeInvocation invocation = this.scope.getCurrentInvocation();
            invocation.setAttachment((Object)nextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if (!this.validate(target, args)) {
            return;
        }
        Trace trace = this.traceContext.currentTraceObject();
        if (trace == null || !trace.canSampled()) {
            return;
        }
        try {
            String exchange = (String)args[0];
            String routingKey = (String)args[1];
            if (exchange == null || exchange.equals("")) {
                exchange = "Unknown";
            }
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            if (throwable == null) {
                AMQConnection amqConnection;
                FrameHandler frameHandler;
                String endPoint = "Unknown";
                Connection connection = ((Channel)target).getConnection();
                if (connection instanceof AMQConnection && (frameHandler = (amqConnection = (AMQConnection)connection).getFrameHandler()) instanceof RemoteAddressAccessor) {
                    endPoint = ((RemoteAddressAccessor)frameHandler)._$PINPOINT$_getRemoteAddress();
                }
                recorder.recordEndPoint(endPoint);
                recorder.recordDestinationId("exchange-" + exchange);
                recorder.recordAttribute(RabbitMQClientConstants.RABBITMQ_EXCHANGE_ANNOTATION_KEY, exchange);
                recorder.recordAttribute(RabbitMQClientConstants.RABBITMQ_ROUTINGKEY_ANNOTATION_KEY, routingKey);
            } else {
                recorder.recordException(throwable);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (!(target instanceof Channel)) {
            return false;
        }
        if (args == null || args.length < 6) {
            return false;
        }
        if (args[0] != null && !(args[0] instanceof String)) {
            return false;
        }
        if (args[1] != null && !(args[1] instanceof String)) {
            return false;
        }
        return args[4] == null || args[4] instanceof AMQP.BasicProperties;
    }
}

