/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test.junit4;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.test.junit4.AfterCallbackStatement;
import com.navercorp.pinpoint.test.junit4.BeforeCallbackStatement;
import com.navercorp.pinpoint.test.junit4.IsRootSpan;
import com.navercorp.pinpoint.test.junit4.TestContext;
import java.lang.reflect.Method;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PinpointJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    private static final Logger logger = LoggerFactory.getLogger(PinpointJUnit4ClassRunner.class);
    private static TestContext testContext;

    public PinpointJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        if (logger.isDebugEnabled()) {
            logger.debug("PinpointJUnit4ClassRunner constructor called with [{}].", clazz);
        }
    }

    private void beforeTestClass() {
        try {
            if (testContext == null) {
                logger.debug("traceContext is null");
                testContext = new TestContext();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected TestClass createTestClass(Class<?> testClass) {
        logger.debug("createTestClass {}", testClass);
        this.beforeTestClass();
        return testContext.createTestClass(testClass);
    }

    private TraceContext getTraceContext() {
        DefaultApplicationContext mockApplicationContext = testContext.getDefaultApplicationContext();
        return mockApplicationContext.getTraceContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.beginTracing(method);
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(testContext.getClassLoader());
            super.runChild(method, notifier);
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
            this.endTracing(method, notifier);
        }
    }

    private void beginTracing(FrameworkMethod method) {
        if (this.shouldCreateNewTraceObject(method)) {
            TraceContext traceContext = this.getTraceContext();
            Trace trace = traceContext.newTraceObject();
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordServiceType(ServiceType.TEST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTracing(FrameworkMethod method, RunNotifier notifier) {
        if (this.shouldCreateNewTraceObject(method)) {
            TraceContext traceContext = this.getTraceContext();
            try {
                Trace trace = traceContext.currentRawTraceObject();
                if (trace == null) {
                    EachTestNotifier testMethodNotifier = new EachTestNotifier(notifier, super.describeChild(method));
                    String traceObjectAlreadyDetachedMessage = "Trace object already detached. If you're testing a trace root, please add @IsRootSpan to the test method";
                    testMethodNotifier.addFailure((Throwable)new IllegalStateException(traceObjectAlreadyDetachedMessage));
                } else {
                    trace.close();
                }
            }
            finally {
                traceContext.removeTraceObject();
            }
        }
    }

    private boolean shouldCreateNewTraceObject(FrameworkMethod method) {
        IsRootSpan isRootSpan = (IsRootSpan)method.getAnnotation(IsRootSpan.class);
        return isRootSpan == null || !isRootSpan.value();
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return super.methodInvoker(method, test);
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, Statement statement) {
        Statement before = super.withBefores(method, target, statement);
        BeforeCallbackStatement callbackStatement = new BeforeCallbackStatement(before, new Statement(){

            public void evaluate() throws Throwable {
                PinpointJUnit4ClassRunner.this.setupBaseTest(target);
            }
        });
        return callbackStatement;
    }

    private void setupBaseTest(Object test) {
        logger.debug("setupBaseTest");
        Class<?> baseTestClass = testContext.getBaseTestClass();
        if (baseTestClass.isInstance(test)) {
            try {
                Method reset = baseTestClass.getDeclaredMethod("setup", TestContext.class);
                reset.invoke(test, testContext);
            }
            catch (Exception e) {
                throw new RuntimeException("setCurrentHolder Error. Caused by:" + e.getMessage(), e);
            }
        }
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement beforeClasses = super.withBeforeClasses(statement);
        return new BeforeCallbackStatement(beforeClasses, new Statement(){

            public void evaluate() throws Throwable {
                PinpointJUnit4ClassRunner.this.beforeClass();
            }
        });
    }

    public void beforeClass() throws Throwable {
        logger.debug("beforeClass");
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement afterClasses = super.withAfterClasses(statement);
        return new AfterCallbackStatement(afterClasses, new Statement(){

            public void evaluate() throws Throwable {
                PinpointJUnit4ClassRunner.this.afterClass();
            }
        });
    }

    public void afterClass() throws Throwable {
        logger.debug("afterClass");
    }
}

