/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.redis.lettuce.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.redis.lettuce.EndPointAccessor;

public class AttachEndPointInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;

    public AttachEndPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block4: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            try {
                if (!this.validate(target, result)) {
                    return;
                }
                String endPoint = ((EndPointAccessor)target)._$PINPOINT$_getEndPoint();
                ((EndPointAccessor)result)._$PINPOINT$_setEndPoint(endPoint);
            }
            catch (Throwable t) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("Failed to AFTER process. {}", (Object)t.getMessage(), (Object)t);
            }
        }
    }

    private boolean validate(Object target, Object result) {
        if (!(target instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor={}, target={}", (Object)EndPointAccessor.class.getName(), target);
            }
            return false;
        }
        if (!(result instanceof EndPointAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid result object. Need field accessor={}, result={}", (Object)EndPointAccessor.class.getName(), result);
            }
            return false;
        }
        return true;
    }
}

