/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.grpc.interceptor.server;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.Assert;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.internal.ServerStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Set;

public class GrpcServerStreamRequest {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final ServerStream serverStream;
    private final String methodName;
    private final Metadata metadata;

    static GrpcServerStreamRequest create(Object[] args) {
        if (GrpcServerStreamRequest.validate(args)) {
            return new GrpcServerStreamRequest((ServerStream)args[0], (String)args[1], (Metadata)args[2]);
        }
        return null;
    }

    static boolean validate(Object[] args) {
        if (ArrayUtils.getLength((Object[])args) == 3) {
            if (!(args[0] instanceof ServerStream)) {
                return false;
            }
            if (!(args[1] instanceof String)) {
                return false;
            }
            return args[2] instanceof Metadata;
        }
        return false;
    }

    GrpcServerStreamRequest(ServerStream serverStream, String methodName, Metadata metadata) {
        this.serverStream = (ServerStream)Assert.requireNonNull((Object)serverStream, (String)"serverStream must not be null");
        this.methodName = (String)Assert.requireNonNull((Object)methodName, (String)"methodName must not be null");
        this.metadata = (Metadata)Assert.requireNonNull((Object)metadata, (String)"metadata must not be null");
    }

    public ServerStream getServerStream() {
        return this.serverStream;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getHeader(String name) {
        Iterator iterator;
        Metadata.Key key = Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Iterable headerValues = this.metadata.removeAll(key);
        String headerValue = null;
        if (headerValues != null && (iterator = headerValues.iterator()).hasNext()) {
            headerValue = (String)iterator.next();
            if (iterator.hasNext()) {
                headerValue = null;
            }
        }
        return headerValue;
    }

    String getRemoteAddress() {
        block7: {
            Attributes attributes = this.serverStream.getAttributes();
            if (attributes == null) {
                return null;
            }
            try {
                Set keys = attributes.keys();
                if (keys == null) {
                    if (this.isDebug) {
                        this.logger.debug("can't attributes keys");
                    }
                    return null;
                }
                for (Attributes.Key key : keys) {
                    if (key == null || !key.toString().equals("remote-addr")) continue;
                    Object remoteAddress = attributes.get(key);
                    if (remoteAddress instanceof SocketAddress) {
                        return GrpcServerStreamRequest.getSocketAddressAsString((SocketAddress)remoteAddress);
                    }
                    if (!(remoteAddress instanceof String)) continue;
                    return (String)remoteAddress;
                }
            }
            catch (Exception e) {
                if (!this.isDebug) break block7;
                this.logger.debug("can't find keys method");
            }
        }
        return "Unknown";
    }

    public static String getSocketAddressAsString(SocketAddress socketAddress) {
        InetSocketAddress inetSocketAddress;
        InetAddress remoteAddress;
        if (socketAddress instanceof InetSocketAddress && (remoteAddress = (inetSocketAddress = (InetSocketAddress)socketAddress).getAddress()) != null) {
            return HostAndPort.toHostAndPortString((String)remoteAddress.getHostAddress(), (int)inetSocketAddress.getPort());
        }
        return "Unknown";
    }

    String getServerAddress() {
        return this.serverStream.getAuthority();
    }
}

