/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.netty.NettyConstants;

public class ChannelPromiseAddListenerInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;

    public ChannelPromiseAddListenerInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(NettyConstants.SERVICE_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            if (this.isAsynchronousInvocation(target, args, result, throwable)) {
                AsyncContext asyncContext = recorder.recordNextAsyncContext();
                ((AsyncContextAccessor)result)._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
                }
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private boolean isAsynchronousInvocation(Object target, Object[] args, Object result, Throwable throwable) {
        if (throwable != null || result == null) {
            return false;
        }
        if (!(result instanceof AsyncContextAccessor)) {
            this.logger.debug("Invalid result object. Need accessor({}).", (Object)AsyncContextAccessor.class.getName());
            return false;
        }
        return true;
    }
}

