/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.util.NetworkUtils;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;

public class HttpServerRequestAdaptor
implements RequestAdaptor<HttpServerRequest> {
    public String getHeader(HttpServerRequest request, String name) {
        return request.getHeader(name);
    }

    public String getRpcName(HttpServerRequest request) {
        return request.path();
    }

    public String getEndPoint(HttpServerRequest request) {
        if (request.localAddress() != null) {
            int port = request.localAddress().port();
            if (port <= 0) {
                return request.host();
            }
            return request.host() + ":" + port;
        }
        return null;
    }

    public String getRemoteAddress(HttpServerRequest request) {
        SocketAddress socketAddress = request.remoteAddress();
        if (socketAddress != null) {
            return socketAddress.toString();
        }
        return "unknown";
    }

    public String getAcceptorHost(HttpServerRequest request) {
        return NetworkUtils.getHostFromURL((String)request.uri().toString());
    }
}

