/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.common.util.StringUtils;
import io.vertx.core.http.HttpServerRequest;
import java.util.List;
import java.util.Map;

public class HttpServerParameterExtractor
implements ParameterExtractor<HttpServerRequest> {
    private int eachLimit;
    private int totalLimit;

    public HttpServerParameterExtractor(int eachLimit, int totalLimit) {
        this.eachLimit = eachLimit;
        this.totalLimit = totalLimit;
    }

    public String extractParameter(HttpServerRequest request) {
        if (request.params() == null) {
            return "";
        }
        StringBuilder params = new StringBuilder(64);
        List entries = request.params().entries();
        for (Map.Entry entry : entries) {
            if (params.length() != 0) {
                params.append('&');
            }
            if (params.length() > this.totalLimit) {
                params.append("...");
                return params.toString();
            }
            String key = (String)entry.getKey();
            params.append(StringUtils.abbreviate((String)key, (int)this.eachLimit));
            params.append('=');
            Object value = entry.getValue();
            if (value == null) continue;
            params.append(StringUtils.abbreviate((String)StringUtils.toString(value), (int)this.eachLimit));
        }
        return params.toString();
    }
}

