/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util;

import com.navercorp.pinpoint.common.util.NetUtils;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public final class NetworkUtils {
    public static final String ERROR_HOST_NAME = "UNKNOWN-HOST";
    private static final String LOOPBACK_ADDRESS_V4_1 = "127.0.0.1";
    private static final String LOOPBACK_ADDRESS_V4_2 = "127.0.1.1";
    private static final String LOOPBACK_ADDRESS_V6 = "0:0:0:0:0:0:0:1";
    private static final List<String> LOOP_BACK_ADDRESS_LIST = new ArrayList<String>(3);

    private NetworkUtils() {
    }

    public static String getHostName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (UnknownHostException e) {
            return NetworkUtils.getMachineName();
        }
    }

    public static String getRepresentationHostIp() {
        String ip = NetworkUtils.getHostIp();
        if (!NetworkUtils.isLoopbackAddress(ip)) {
            return ip;
        }
        List<String> ipList = NetworkUtils.getHostIpList();
        if (!ipList.isEmpty()) {
            return ipList.get(0);
        }
        return LOOPBACK_ADDRESS_V4_1;
    }

    public static String getHostIp() {
        String hostIp;
        try {
            InetAddress thisIp = InetAddress.getLocalHost();
            hostIp = thisIp.getHostAddress();
        }
        catch (UnknownHostException e) {
            CommonLogger logger = NetworkUtils.getLogger();
            logger.warn(e.getMessage());
            hostIp = LOOPBACK_ADDRESS_V4_1;
        }
        return hostIp;
    }

    public static List<String> getHostIpList() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ignore) {
            // empty catch block
        }
        if (interfaces == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (NetworkUtils.isSkipNetworkInterface(current)) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                String hostAddress;
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || NetworkUtils.isLoopbackAddress(hostAddress = address.getHostAddress())) continue;
                result.add(address.getHostAddress());
            }
        }
        return result;
    }

    public static String getHostV4Ip() {
        String hostIp = NetworkUtils.getHostIp();
        if (NetworkUtils.validationIpV4FormatAddress(hostIp)) {
            return hostIp;
        }
        return LOOPBACK_ADDRESS_V4_1;
    }

    public static List<String> getHostV4IpList() {
        List<String> hostIpList = NetworkUtils.getHostIpList();
        ArrayList<String> hostV4IpList = new ArrayList<String>(hostIpList.size());
        for (String ip : hostIpList) {
            if (!NetworkUtils.validationIpV4FormatAddress(ip)) continue;
            hostV4IpList.add(ip);
        }
        return hostV4IpList;
    }

    private static boolean isSkipNetworkInterface(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isLoopbackAddress(String ip) {
        if (ip == null) {
            return true;
        }
        return LOOP_BACK_ADDRESS_LIST.contains(ip);
    }

    public static boolean validationIpV4FormatAddress(String address) {
        return NetUtils.validationIpV4FormatAddress((String)address);
    }

    private static CommonLogger getLogger() {
        return StdoutCommonLoggerFactory.INSTANCE.getLogger(NetworkUtils.class.getClass().getName());
    }

    @Deprecated
    public static String getMachineName() {
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            while (enet.hasMoreElements()) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress inet = eaddr.nextElement();
                    String canonicalHostName = inet.getCanonicalHostName();
                    if (canonicalHostName.equalsIgnoreCase(inet.getHostAddress())) continue;
                    return canonicalHostName;
                }
            }
            return ERROR_HOST_NAME;
        }
        catch (SocketException e) {
            CommonLogger logger = NetworkUtils.getLogger();
            logger.warn(e.getMessage());
            return ERROR_HOST_NAME;
        }
    }

    public static String getHostFromURL(String urlSpec) {
        if (urlSpec == null) {
            return null;
        }
        try {
            URL url = new URL(urlSpec);
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                return host;
            }
            return host + ":" + port;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    static {
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V4_1);
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V4_2);
        LOOP_BACK_ADDRESS_LIST.add(LOOPBACK_ADDRESS_V6);
    }
}

