/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.rxjava.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.plugin.rxjava.interceptor.WorkerScheduleInterceptor;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.VarArgs;
import java.security.ProtectionDomain;

public class SchedulerWorkerTransformCallback
implements TransformCallback {
    private final ServiceType serviceType;

    private SchedulerWorkerTransformCallback(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public static SchedulerWorkerTransformCallback createFor(ServiceType serviceType) {
        return new SchedulerWorkerTransformCallback(serviceType);
    }

    @Override
    public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
        InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
        for (InstrumentMethod schedule : target.getDeclaredMethods(MethodFilters.chain(MethodFilters.name("schedule"), MethodFilters.argAt(0, "rx.functions.Action0")))) {
            if (schedule == null) continue;
            schedule.addScopedInterceptor(WorkerScheduleInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{this.serviceType}), "RxJavaSchedulerWorkerScope", ExecutionPolicy.BOUNDARY);
        }
        return target.toBytecode();
    }
}

