/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.proxy;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.LongIntIntByteByteStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;

public class ProxyHttpHeader {
    public static final int TYPE_APP = 1;
    public static final int TYPE_NGINX = 2;
    public static final int TYPE_APACHE = 3;
    private static final int APP_MAX_LENGTH = 32;
    private final int type;
    private long receivedTimeMillis;
    private int durationTimeMicroseconds = -1;
    private byte idlePercent = (byte)-1;
    private byte busyPercent = (byte)-1;
    private String app;
    private boolean valid = false;
    private String cause = "required value not set";

    public ProxyHttpHeader(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public long getReceivedTimeMillis() {
        return this.receivedTimeMillis;
    }

    public void setReceivedTimeMillis(long receivedTimeMillis) {
        this.receivedTimeMillis = receivedTimeMillis;
    }

    public int getDurationTimeMicroseconds() {
        return this.durationTimeMicroseconds;
    }

    public void setDurationTimeMicroseconds(int durationTimeMicroseconds) {
        this.durationTimeMicroseconds = durationTimeMicroseconds;
    }

    public byte getIdlePercent() {
        return this.idlePercent;
    }

    public void setIdlePercent(byte idlePercent) {
        this.idlePercent = idlePercent;
    }

    public byte getBusyPercent() {
        return this.busyPercent;
    }

    public void setBusyPercent(byte busyPercent) {
        this.busyPercent = busyPercent;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public AnnotationKey getAnnotationKey() {
        return AnnotationKey.PROXY_HTTP_HEADER;
    }

    public Object getAnnotationValue() {
        if (this.type == 1 && this.app != null) {
            return new LongIntIntByteByteStringValue(this.receivedTimeMillis, this.type, this.durationTimeMicroseconds, this.idlePercent, this.busyPercent, StringUtils.abbreviate((String)this.app, (int)32));
        }
        return new LongIntIntByteByteStringValue(this.receivedTimeMillis, this.type, this.durationTimeMicroseconds, this.idlePercent, this.busyPercent, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProxyHttpHeader{");
        sb.append("type=").append(this.type);
        sb.append(", receivedTimeMillis=").append(this.receivedTimeMillis);
        sb.append(", durationTimeMicroseconds=").append(this.durationTimeMicroseconds);
        sb.append(", idlePercent=").append(this.idlePercent);
        sb.append(", busyPercent=").append(this.busyPercent);
        sb.append(", app='").append(this.app).append('\'');
        sb.append(", valid=").append(this.valid);
        sb.append(", cause='").append(this.cause).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

