/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.HttpStatusCodeErrors;
import com.navercorp.pinpoint.bootstrap.config.InstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilableClassFilter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.bootstrap.util.spring.PropertyPlaceholderHelper;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.PropertyUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class DefaultProfilerConfig
implements ProfilerConfig {
    private static final CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(DefaultProfilerConfig.class.getName());
    private static final String DEFAULT_IP = "127.0.0.1";
    private final Properties properties;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
    public static final String INSTRUMENT_ENGINE_ASM = "ASM";
    public static final int DEFAULT_AGENT_STAT_COLLECTION_INTERVAL_MS = 5000;
    public static final int DEFAULT_NUM_AGENT_STAT_BATCH_SEND = 6;
    private boolean profileEnable = false;
    private String profileInstrumentEngine = "ASM";
    private boolean instrumentMatcherEnable = true;
    private InstrumentMatcherCacheConfig instrumentMatcherCacheConfig = new InstrumentMatcherCacheConfig();
    private int interceptorRegistrySize = 8192;
    @VisibleForTesting
    private boolean staticResourceCleanup = false;
    private String collectorSpanServerIp = "127.0.0.1";
    private int collectorSpanServerPort = 9996;
    private String collectorStatServerIp = "127.0.0.1";
    private int collectorStatServerPort = 9995;
    private String collectorTcpServerIp = "127.0.0.1";
    private int collectorTcpServerPort = 9994;
    private int spanDataSenderWriteQueueSize = 5120;
    private int spanDataSenderSocketSendBufferSize = 0x100000;
    private int spanDataSenderSocketTimeout = 3000;
    private int spanDataSenderChunkSize = 16384;
    private static String DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK = "16m";
    private String spanDataSenderWriteBufferHighWaterMark = DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK;
    private static String DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK = "8m";
    private String spanDataSenderWriteBufferLowWaterMark = DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK;
    private String spanDataSenderTransportType = "UDP";
    private String spanDataSenderSocketType = "OIO";
    private int statDataSenderWriteQueueSize = 5120;
    private int statDataSenderSocketSendBufferSize = 0x100000;
    private int statDataSenderSocketTimeout = 3000;
    private int statDataSenderChunkSize = 16384;
    private static String DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK = "16m";
    private String statDataSenderWriteBufferHighWaterMark = DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK;
    private static String DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK = "8m";
    private String statDataSenderWriteBufferLowWaterMark = DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK;
    private String statDataSenderTransportType = "UDP";
    private String statDataSenderSocketType = "OIO";
    private boolean tcpDataSenderCommandAcceptEnable = false;
    private boolean tcpDataSenderCommandActiveThreadEnable = false;
    private boolean tcpDataSenderCommandActiveThreadCountEnable = false;
    private boolean tcpDataSenderCommandActiveThreadDumpEnable = false;
    private boolean tcpDataSenderCommandActiveThreadLightDumpEnable = false;
    private static long DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_TIMEOUT = 3000L;
    private long tcpDataSenderPinpointClientWriteTimeout = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_TIMEOUT;
    private static long DEFAULT_DATA_SENDER_PINPOINT_CLIENT_REQUEST_TIMEOUT = 3000L;
    private long tcpDataSenderPinpointClientRequestTimeout = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_REQUEST_TIMEOUT;
    private static long DEFAULT_DATA_SENDER_PINPOINT_CLIENT_RECONNECT_INTERVAL = 3000L;
    private long tcpDataSenderPinpointClientReconnectInterval = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_RECONNECT_INTERVAL;
    private static long DEFAULT_DATA_SENDER_PINPOINT_CLIENT_PING_INTERVAL = 300000L;
    private long tcpDataSenderPinpointClientPingInterval = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_PING_INTERVAL;
    private static long DEFAULT_DATA_SENDER_PINPOINT_CLIENT_HANDSHAKE_INTERVAL = 60000L;
    private long tcpDataSenderPinpointClientHandshakeInterval = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_HANDSHAKE_INTERVAL;
    private static String DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_HIGH_WATER_MAK = "32m";
    private String tcpDataSenderPinpointClientWriteBufferHighWaterMark = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_HIGH_WATER_MAK;
    private static String DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_LOW_WATER_MAK = "16m";
    private String tcpDataSenderPinpointClientWriteBufferLowWaterMark = DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_LOW_WATER_MAK;
    private boolean traceAgentActiveThread = true;
    private boolean traceAgentDataSource = false;
    private int dataSourceTraceLimitSize = 20;
    private boolean deadlockMonitorEnable = true;
    private long deadlockMonitorInterval = 60000L;
    private int callStackMaxDepth = 512;
    private int jdbcSqlCacheSize = 1024;
    private boolean traceSqlBindValue = false;
    private int maxSqlBindValueSize = 1024;
    private boolean samplingEnable = true;
    private int samplingRate = 1;
    private int samplingNewThroughput = 0;
    private int samplingContinueThroughput = 0;
    private boolean ioBufferingEnable;
    private int ioBufferingBufferSize;
    private String profileJvmVendorName;
    private String profileOsName;
    private int profileJvmStatCollectIntervalMs = 5000;
    private int profileJvmStatBatchSendCount = 6;
    private boolean profilerJvmStatCollectDetailedMetrics;
    private Filter<String> profilableClassFilter = new SkipFilter<String>();
    private final long DEFAULT_AGENT_INFO_SEND_RETRY_INTERVAL = 300000L;
    private long agentInfoSendRetryInterval = 300000L;
    private String applicationServerType;
    private List<String> applicationTypeDetectOrder = Collections.emptyList();
    private List<String> disabledPlugins = Collections.emptyList();
    private boolean propagateInterceptorException = false;
    private boolean supportLambdaExpressions = true;
    private boolean proxyHttpHeaderEnable = true;
    private HttpStatusCodeErrors httpStatusCodeErrors = new HttpStatusCodeErrors();
    private String injectionModuleFactoryClazzName = null;
    private String applicationNamespace = "";

    public static ProfilerConfig load(String pinpointConfigFileName) throws IOException {
        try {
            Properties properties = PropertyUtils.loadProperty((String)pinpointConfigFileName);
            return new DefaultProfilerConfig(properties);
        }
        catch (FileNotFoundException fe) {
            if (logger.isWarnEnabled()) {
                logger.warn(pinpointConfigFileName + " file does not exist. Please check your configuration.");
            }
            throw fe;
        }
        catch (IOException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(pinpointConfigFileName + " file I/O error. Error:" + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public DefaultProfilerConfig() {
        this.properties = new Properties();
    }

    public DefaultProfilerConfig(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties must not be null");
        }
        this.properties = properties;
        this.readPropertyValues();
    }

    @Override
    public int getInterceptorRegistrySize() {
        return this.interceptorRegistrySize;
    }

    @Override
    public String getCollectorSpanServerIp() {
        return this.collectorSpanServerIp;
    }

    @Override
    public int getCollectorSpanServerPort() {
        return this.collectorSpanServerPort;
    }

    @Override
    public String getCollectorStatServerIp() {
        return this.collectorStatServerIp;
    }

    @Override
    public int getCollectorStatServerPort() {
        return this.collectorStatServerPort;
    }

    @Override
    public String getCollectorTcpServerIp() {
        return this.collectorTcpServerIp;
    }

    @Override
    public int getCollectorTcpServerPort() {
        return this.collectorTcpServerPort;
    }

    @Override
    public int getStatDataSenderWriteQueueSize() {
        return this.statDataSenderWriteQueueSize;
    }

    @Override
    public int getStatDataSenderSocketSendBufferSize() {
        return this.statDataSenderSocketSendBufferSize;
    }

    @Override
    public int getStatDataSenderSocketTimeout() {
        return this.statDataSenderSocketTimeout;
    }

    @Override
    public String getStatDataSenderWriteBufferHighWaterMark() {
        return this.statDataSenderWriteBufferHighWaterMark;
    }

    @Override
    public String getStatDataSenderWriteBufferLowWaterMark() {
        return this.statDataSenderWriteBufferLowWaterMark;
    }

    @Override
    public String getStatDataSenderSocketType() {
        return this.statDataSenderSocketType;
    }

    @Override
    public String getStatDataSenderTransportType() {
        return this.statDataSenderTransportType;
    }

    @Override
    public int getSpanDataSenderWriteQueueSize() {
        return this.spanDataSenderWriteQueueSize;
    }

    @Override
    public int getSpanDataSenderSocketSendBufferSize() {
        return this.spanDataSenderSocketSendBufferSize;
    }

    @Override
    public boolean isTcpDataSenderCommandAcceptEnable() {
        return this.tcpDataSenderCommandAcceptEnable;
    }

    @Override
    public boolean isTcpDataSenderCommandActiveThreadEnable() {
        return this.tcpDataSenderCommandActiveThreadEnable;
    }

    @Override
    public boolean isTcpDataSenderCommandActiveThreadCountEnable() {
        return this.tcpDataSenderCommandActiveThreadCountEnable;
    }

    @Override
    public boolean isTcpDataSenderCommandActiveThreadDumpEnable() {
        return this.tcpDataSenderCommandActiveThreadDumpEnable;
    }

    @Override
    public boolean isTcpDataSenderCommandActiveThreadLightDumpEnable() {
        return this.tcpDataSenderCommandActiveThreadLightDumpEnable;
    }

    @Override
    public long getTcpDataSenderPinpointClientWriteTimeout() {
        return this.tcpDataSenderPinpointClientWriteTimeout;
    }

    @Override
    public long getTcpDataSenderPinpointClientRequestTimeout() {
        return this.tcpDataSenderPinpointClientRequestTimeout;
    }

    @Override
    public long getTcpDataSenderPinpointClientReconnectInterval() {
        return this.tcpDataSenderPinpointClientReconnectInterval;
    }

    @Override
    public long getTcpDataSenderPinpointClientPingInterval() {
        return this.tcpDataSenderPinpointClientPingInterval;
    }

    @Override
    public long getTcpDataSenderPinpointClientHandshakeInterval() {
        return this.tcpDataSenderPinpointClientHandshakeInterval;
    }

    @Override
    public String getTcpDataSenderPinpointClientWriteBufferHighWaterMark() {
        return this.tcpDataSenderPinpointClientWriteBufferHighWaterMark;
    }

    @Override
    public String getTcpDataSenderPinpointClientWriteBufferLowWaterMark() {
        return this.tcpDataSenderPinpointClientWriteBufferLowWaterMark;
    }

    @Override
    public boolean isTraceAgentActiveThread() {
        return this.traceAgentActiveThread;
    }

    @Override
    public boolean isTraceAgentDataSource() {
        return this.traceAgentDataSource;
    }

    @Override
    public int getDataSourceTraceLimitSize() {
        return this.dataSourceTraceLimitSize;
    }

    @Override
    public boolean isDeadlockMonitorEnable() {
        return this.deadlockMonitorEnable;
    }

    @Override
    public long getDeadlockMonitorInterval() {
        return this.deadlockMonitorInterval;
    }

    @Override
    public int getSpanDataSenderSocketTimeout() {
        return this.spanDataSenderSocketTimeout;
    }

    @Override
    public String getSpanDataSenderSocketType() {
        return this.spanDataSenderSocketType;
    }

    @Override
    public String getSpanDataSenderTransportType() {
        return this.spanDataSenderTransportType;
    }

    @Override
    public String getSpanDataSenderWriteBufferHighWaterMark() {
        return this.spanDataSenderWriteBufferHighWaterMark;
    }

    @Override
    public String getSpanDataSenderWriteBufferLowWaterMark() {
        return this.spanDataSenderWriteBufferLowWaterMark;
    }

    @Override
    public int getSpanDataSenderChunkSize() {
        return this.spanDataSenderChunkSize;
    }

    @Override
    public int getStatDataSenderChunkSize() {
        return this.statDataSenderChunkSize;
    }

    @Override
    public boolean isProfileEnable() {
        return this.profileEnable;
    }

    @Override
    public int getJdbcSqlCacheSize() {
        return this.jdbcSqlCacheSize;
    }

    @Override
    public boolean isTraceSqlBindValue() {
        return this.traceSqlBindValue;
    }

    @Override
    public int getMaxSqlBindValueSize() {
        return this.maxSqlBindValueSize;
    }

    @Override
    public boolean isSamplingEnable() {
        return this.samplingEnable;
    }

    @Override
    public int getSamplingRate() {
        return this.samplingRate;
    }

    @Override
    public int getSamplingNewThroughput() {
        return this.samplingNewThroughput;
    }

    @Override
    public int getSamplingContinueThroughput() {
        return this.samplingContinueThroughput;
    }

    @Override
    public boolean isIoBufferingEnable() {
        return this.ioBufferingEnable;
    }

    @Override
    public int getIoBufferingBufferSize() {
        return this.ioBufferingBufferSize;
    }

    @Override
    public String getProfilerJvmVendorName() {
        return this.profileJvmVendorName;
    }

    @Override
    public String getProfilerOSName() {
        return this.profileOsName;
    }

    @Override
    public int getProfileJvmStatCollectIntervalMs() {
        return this.profileJvmStatCollectIntervalMs;
    }

    @Override
    public int getProfileJvmStatBatchSendCount() {
        return this.profileJvmStatBatchSendCount;
    }

    @Override
    public boolean isProfilerJvmStatCollectDetailedMetrics() {
        return this.profilerJvmStatCollectDetailedMetrics;
    }

    @Override
    public long getAgentInfoSendRetryInterval() {
        return this.agentInfoSendRetryInterval;
    }

    @Override
    public boolean getStaticResourceCleanup() {
        return this.staticResourceCleanup;
    }

    public void setStaticResourceCleanup(boolean staticResourceCleanup) {
        this.staticResourceCleanup = staticResourceCleanup;
    }

    @Override
    public Filter<String> getProfilableClassFilter() {
        return this.profilableClassFilter;
    }

    @Override
    public List<String> getApplicationTypeDetectOrder() {
        return this.applicationTypeDetectOrder;
    }

    @Override
    public List<String> getDisabledPlugins() {
        return this.disabledPlugins;
    }

    @Override
    public String getApplicationServerType() {
        return this.applicationServerType;
    }

    public void setApplicationServerType(String applicationServerType) {
        this.applicationServerType = applicationServerType;
    }

    @Override
    public int getCallStackMaxDepth() {
        return this.callStackMaxDepth;
    }

    public void setCallStackMaxDepth(int callStackMaxDepth) {
        this.callStackMaxDepth = callStackMaxDepth;
    }

    @Override
    public boolean isPropagateInterceptorException() {
        return this.propagateInterceptorException;
    }

    @Override
    public String getProfileInstrumentEngine() {
        return this.profileInstrumentEngine;
    }

    @Override
    public boolean isSupportLambdaExpressions() {
        return this.supportLambdaExpressions;
    }

    @Override
    public boolean isInstrumentMatcherEnable() {
        return this.instrumentMatcherEnable;
    }

    @Override
    public InstrumentMatcherCacheConfig getInstrumentMatcherCacheConfig() {
        return this.instrumentMatcherCacheConfig;
    }

    @Override
    public boolean isProxyHttpHeaderEnable() {
        return this.proxyHttpHeaderEnable;
    }

    @Override
    public HttpStatusCodeErrors getHttpStatusCodeErrors() {
        return this.httpStatusCodeErrors;
    }

    @Override
    public String getInjectionModuleFactoryClazzName() {
        return this.injectionModuleFactoryClazzName;
    }

    @Override
    public String getApplicationNamespace() {
        return this.applicationNamespace;
    }

    void readPropertyValues() {
        PlaceHolderResolver placeHolderResolver = new PlaceHolderResolver();
        this.profileEnable = this.readBoolean("profiler.enable", true);
        this.profileInstrumentEngine = this.readString("profiler.instrument.engine", INSTRUMENT_ENGINE_ASM);
        this.instrumentMatcherEnable = this.readBoolean("profiler.instrument.matcher.enable", true);
        this.instrumentMatcherCacheConfig.setInterfaceCacheSize(this.readInt("profiler.instrument.matcher.interface.cache.size", 4));
        this.instrumentMatcherCacheConfig.setInterfaceCacheEntrySize(this.readInt("profiler.instrument.matcher.interface.cache.entry.size", 16));
        this.instrumentMatcherCacheConfig.setAnnotationCacheSize(this.readInt("profiler.instrument.matcher.annotation.cache.size", 4));
        this.instrumentMatcherCacheConfig.setAnnotationCacheEntrySize(this.readInt("profiler.instrument.matcher.annotation.cache.entry.size", 4));
        this.instrumentMatcherCacheConfig.setSuperCacheSize(this.readInt("profiler.instrument.matcher.super.cache.size", 4));
        this.instrumentMatcherCacheConfig.setSuperCacheEntrySize(this.readInt("profiler.instrument.matcher.super.cache.entry.size", 4));
        this.interceptorRegistrySize = this.readInt("profiler.interceptorregistry.size", 8192);
        this.collectorSpanServerIp = this.readString("profiler.collector.span.ip", DEFAULT_IP, placeHolderResolver);
        this.collectorSpanServerPort = this.readInt("profiler.collector.span.port", 9996);
        this.collectorStatServerIp = this.readString("profiler.collector.stat.ip", DEFAULT_IP, placeHolderResolver);
        this.collectorStatServerPort = this.readInt("profiler.collector.stat.port", 9995);
        this.collectorTcpServerIp = this.readString("profiler.collector.tcp.ip", DEFAULT_IP, placeHolderResolver);
        this.collectorTcpServerPort = this.readInt("profiler.collector.tcp.port", 9994);
        this.spanDataSenderWriteQueueSize = this.readInt("profiler.spandatasender.write.queue.size", 5120);
        this.spanDataSenderSocketSendBufferSize = this.readInt("profiler.spandatasender.socket.sendbuffersize", 0x100000);
        this.spanDataSenderSocketTimeout = this.readInt("profiler.spandatasender.socket.timeout", 3000);
        this.spanDataSenderChunkSize = this.readInt("profiler.spandatasender.chunk.size", 16384);
        this.spanDataSenderWriteBufferHighWaterMark = this.readString("profiler.spandatasender.write.buffer.highwatermark", DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK);
        this.spanDataSenderWriteBufferLowWaterMark = this.readString("profiler.spandatasender.write.buffer.lowwatermark", DEFAULT_SPAN_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK);
        this.spanDataSenderSocketType = this.readString("profiler.spandatasender.socket.type", "OIO");
        this.spanDataSenderTransportType = this.readString("profiler.spandatasender.transport.type", "UDP");
        this.statDataSenderWriteQueueSize = this.readInt("profiler.statdatasender.write.queue.size", 5120);
        this.statDataSenderSocketSendBufferSize = this.readInt("profiler.statdatasender.socket.sendbuffersize", 0x100000);
        this.statDataSenderSocketTimeout = this.readInt("profiler.statdatasender.socket.timeout", 3000);
        this.statDataSenderChunkSize = this.readInt("profiler.statdatasender.chunk.size", 16384);
        this.statDataSenderWriteBufferHighWaterMark = this.readString("profiler.statdatasender.write.buffer.highwatermark", DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_HIGH_WATER_MAK);
        this.statDataSenderWriteBufferLowWaterMark = this.readString("profiler.statdatasender.write.buffer.lowwatermark", DEFAULT_STAT_DATA_SENDER_WRITE_BUFFER_LOW_WATER_MAK);
        this.statDataSenderSocketType = this.readString("profiler.statdatasender.socket.type", "OIO");
        this.statDataSenderTransportType = this.readString("profiler.statdatasender.transport.type", "UDP");
        this.tcpDataSenderCommandAcceptEnable = this.readBoolean("profiler.tcpdatasender.command.accept.enable", false);
        this.tcpDataSenderCommandActiveThreadEnable = this.readBoolean("profiler.tcpdatasender.command.activethread.enable", false);
        this.tcpDataSenderCommandActiveThreadCountEnable = this.readBoolean("profiler.tcpdatasender.command.activethread.count.enable", false);
        this.tcpDataSenderCommandActiveThreadDumpEnable = this.readBoolean("profiler.tcpdatasender.command.activethread.threaddump.enable", false);
        this.tcpDataSenderCommandActiveThreadLightDumpEnable = this.readBoolean("profiler.tcpdatasender.command.activethread.threadlightdump.enable", false);
        this.tcpDataSenderPinpointClientWriteTimeout = this.readLong("profiler.tcpdatasender.client.write.timeout", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_TIMEOUT);
        this.tcpDataSenderPinpointClientRequestTimeout = this.readLong("profiler.tcpdatasender.client.request.timeout", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_REQUEST_TIMEOUT);
        this.tcpDataSenderPinpointClientReconnectInterval = this.readLong("profiler.tcpdatasender.client.reconnect.interval", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_RECONNECT_INTERVAL);
        this.tcpDataSenderPinpointClientPingInterval = this.readLong("profiler.tcpdatasender.client.ping.interval", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_PING_INTERVAL);
        this.tcpDataSenderPinpointClientHandshakeInterval = this.readLong("profiler.tcpdatasender.client.handshake.interval", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_HANDSHAKE_INTERVAL);
        this.tcpDataSenderPinpointClientWriteBufferHighWaterMark = this.readString("profiler.tcpdatasender.client.write.buffer.highwatermark", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_HIGH_WATER_MAK);
        this.tcpDataSenderPinpointClientWriteBufferLowWaterMark = this.readString("profiler.tcpdatasender.client.write.buffer.lowwatermark", DEFAULT_DATA_SENDER_PINPOINT_CLIENT_WRITE_BUFFER_LOW_WATER_MAK);
        this.traceAgentActiveThread = this.readBoolean("profiler.pinpoint.activethread", true);
        this.traceAgentDataSource = this.readBoolean("profiler.pinpoint.datasource", false);
        this.dataSourceTraceLimitSize = this.readInt("profiler.pinpoint.datasource.tracelimitsize", 20);
        this.deadlockMonitorEnable = this.readBoolean("profiler.monitor.deadlock.enable", true);
        this.deadlockMonitorInterval = this.readLong("profiler.monitor.deadlock.interval", 60000L);
        this.callStackMaxDepth = this.readInt("profiler.callstack.max.depth", 64);
        if (this.callStackMaxDepth != -1 && this.callStackMaxDepth < 2) {
            this.callStackMaxDepth = 2;
        }
        this.jdbcSqlCacheSize = this.readInt("profiler.jdbc.sqlcachesize", 1024);
        this.traceSqlBindValue = this.readBoolean("profiler.jdbc.tracesqlbindvalue", false);
        this.samplingEnable = this.readBoolean("profiler.sampling.enable", true);
        this.samplingRate = this.readInt("profiler.sampling.rate", 1);
        this.samplingNewThroughput = this.readInt("profiler.sampling.new.throughput", 0);
        this.samplingContinueThroughput = this.readInt("profiler.sampling.continue.throughput", 0);
        this.ioBufferingEnable = this.readBoolean("profiler.io.buffering.enable", true);
        this.ioBufferingBufferSize = this.readInt("profiler.io.buffering.buffersize", 20);
        this.profileOsName = this.readString("profiler.os.name", null);
        this.profileJvmVendorName = this.readString("profiler.jvm.vendor.name", null);
        this.profileJvmStatCollectIntervalMs = this.readInt("profiler.jvm.stat.collect.interval", 5000);
        this.profileJvmStatBatchSendCount = this.readInt("profiler.jvm.stat.batch.send.count", 6);
        this.profilerJvmStatCollectDetailedMetrics = this.readBoolean("profiler.jvm.stat.collect.detailed.metrics", false);
        this.agentInfoSendRetryInterval = this.readLong("profiler.agentInfo.send.retry.interval", 300000L);
        this.applicationServerType = this.readString("profiler.applicationservertype", null);
        this.applicationTypeDetectOrder = this.readList("profiler.type.detect.order");
        this.disabledPlugins = this.readList("profiler.plugin.disable");
        String profilableClass = this.readString("profiler.include", "");
        if (!profilableClass.isEmpty()) {
            this.profilableClassFilter = new ProfilableClassFilter(profilableClass);
        }
        this.propagateInterceptorException = this.readBoolean("profiler.interceptor.exception.propagate", false);
        this.supportLambdaExpressions = this.readBoolean("profiler.lambda.expressions.support", true);
        this.proxyHttpHeaderEnable = this.readBoolean("profiler.proxy.http.header.enable", true);
        this.httpStatusCodeErrors = new HttpStatusCodeErrors(this.readList("profiler.http.status.code.errors"));
        this.injectionModuleFactoryClazzName = this.readString("profiler.guice.module.factory", null);
        this.applicationNamespace = this.readString("profiler.application.namespace", "");
        logger.info("configuration loaded successfully.");
    }

    @Override
    public String readString(String propertyName, String defaultValue) {
        return this.readString(propertyName, defaultValue, BypassResolver.RESOLVER);
    }

    private String readString(String propertyName, String defaultValue, ValueResolver valueResolver) {
        if (valueResolver == null) {
            throw new NullPointerException("valueResolver must not be null");
        }
        String value = this.properties.getProperty(propertyName, defaultValue);
        value = valueResolver.resolve(value, this.properties);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + value);
        }
        return value;
    }

    @Override
    public int readInt(String propertyName, int defaultValue) {
        String value = this.properties.getProperty(propertyName);
        int result = NumberUtils.parseInteger(value, defaultValue);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public DumpType readDumpType(String propertyName, DumpType defaultDump) {
        DumpType result;
        String propertyValue = this.properties.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = defaultDump.name();
        }
        String value = propertyValue.toUpperCase();
        try {
            result = DumpType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            result = defaultDump;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + (Object)((Object)result));
        }
        return result;
    }

    @Override
    public long readLong(String propertyName, long defaultValue) {
        String value = this.properties.getProperty(propertyName);
        long result = NumberUtils.parseLong(value, defaultValue);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public List<String> readList(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (StringUtils.isEmpty((String)value)) {
            return Collections.emptyList();
        }
        return StringUtils.tokenizeToStringList((String)value, (String)",");
    }

    @Override
    public boolean readBoolean(String propertyName, boolean defaultValue) {
        String value = this.properties.getProperty(propertyName, Boolean.toString(defaultValue));
        boolean result = Boolean.parseBoolean(value);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public Map<String, String> readPattern(String propertyNamePatternRegex) {
        Pattern pattern = Pattern.compile(propertyNamePatternRegex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !pattern.matcher(key = (String)entry.getKey()).matches()) continue;
            String value = (String)entry.getValue();
            result.put(key, value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(propertyNamePatternRegex + "=" + result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultProfilerConfig{");
        sb.append("properties=").append(this.properties);
        sb.append(", propertyPlaceholderHelper=").append(this.propertyPlaceholderHelper);
        sb.append(", profileEnable=").append(this.profileEnable);
        sb.append(", profileInstrumentEngine='").append(this.profileInstrumentEngine).append('\'');
        sb.append(", instrumentMatcherEnable=").append(this.instrumentMatcherEnable);
        sb.append(", instrumentMatcherCacheConfig=").append(this.instrumentMatcherCacheConfig);
        sb.append(", interceptorRegistrySize=").append(this.interceptorRegistrySize);
        sb.append(", staticResourceCleanup=").append(this.staticResourceCleanup);
        sb.append(", collectorSpanServerIp='").append(this.collectorSpanServerIp).append('\'');
        sb.append(", collectorSpanServerPort=").append(this.collectorSpanServerPort);
        sb.append(", collectorStatServerIp='").append(this.collectorStatServerIp).append('\'');
        sb.append(", collectorStatServerPort=").append(this.collectorStatServerPort);
        sb.append(", collectorTcpServerIp='").append(this.collectorTcpServerIp).append('\'');
        sb.append(", collectorTcpServerPort=").append(this.collectorTcpServerPort);
        sb.append(", spanDataSenderWriteQueueSize=").append(this.spanDataSenderWriteQueueSize);
        sb.append(", spanDataSenderSocketSendBufferSize=").append(this.spanDataSenderSocketSendBufferSize);
        sb.append(", spanDataSenderSocketTimeout=").append(this.spanDataSenderSocketTimeout);
        sb.append(", spanDataSenderChunkSize=").append(this.spanDataSenderChunkSize);
        sb.append(", spanDataSenderWriteBufferHighWaterMark='").append(this.spanDataSenderWriteBufferHighWaterMark).append('\'');
        sb.append(", spanDataSenderWriteBufferLowWaterMark='").append(this.spanDataSenderWriteBufferLowWaterMark).append('\'');
        sb.append(", spanDataSenderTransportType='").append(this.spanDataSenderTransportType).append('\'');
        sb.append(", spanDataSenderSocketType='").append(this.spanDataSenderSocketType).append('\'');
        sb.append(", statDataSenderWriteQueueSize=").append(this.statDataSenderWriteQueueSize);
        sb.append(", statDataSenderSocketSendBufferSize=").append(this.statDataSenderSocketSendBufferSize);
        sb.append(", statDataSenderSocketTimeout=").append(this.statDataSenderSocketTimeout);
        sb.append(", statDataSenderChunkSize=").append(this.statDataSenderChunkSize);
        sb.append(", statDataSenderWriteBufferHighWaterMark='").append(this.statDataSenderWriteBufferHighWaterMark).append('\'');
        sb.append(", statDataSenderWriteBufferLowWaterMark='").append(this.statDataSenderWriteBufferLowWaterMark).append('\'');
        sb.append(", statDataSenderTransportType='").append(this.statDataSenderTransportType).append('\'');
        sb.append(", statDataSenderSocketType='").append(this.statDataSenderSocketType).append('\'');
        sb.append(", tcpDataSenderCommandAcceptEnable=").append(this.tcpDataSenderCommandAcceptEnable);
        sb.append(", tcpDataSenderCommandActiveThreadEnable=").append(this.tcpDataSenderCommandActiveThreadEnable);
        sb.append(", tcpDataSenderCommandActiveThreadCountEnable=").append(this.tcpDataSenderCommandActiveThreadCountEnable);
        sb.append(", tcpDataSenderCommandActiveThreadDumpEnable=").append(this.tcpDataSenderCommandActiveThreadDumpEnable);
        sb.append(", tcpDataSenderCommandActiveThreadLightDumpEnable=").append(this.tcpDataSenderCommandActiveThreadLightDumpEnable);
        sb.append(", tcpDataSenderPinpointClientWriteTimeout=").append(this.tcpDataSenderPinpointClientWriteTimeout);
        sb.append(", tcpDataSenderPinpointClientRequestTimeout=").append(this.tcpDataSenderPinpointClientRequestTimeout);
        sb.append(", tcpDataSenderPinpointClientReconnectInterval=").append(this.tcpDataSenderPinpointClientReconnectInterval);
        sb.append(", tcpDataSenderPinpointClientPingInterval=").append(this.tcpDataSenderPinpointClientPingInterval);
        sb.append(", tcpDataSenderPinpointClientHandshakeInterval=").append(this.tcpDataSenderPinpointClientHandshakeInterval);
        sb.append(", tcpDataSenderPinpointClientWriteBufferHighWaterMark='").append(this.tcpDataSenderPinpointClientWriteBufferHighWaterMark).append('\'');
        sb.append(", tcpDataSenderPinpointClientWriteBufferLowWaterMark='").append(this.tcpDataSenderPinpointClientWriteBufferLowWaterMark).append('\'');
        sb.append(", traceAgentActiveThread=").append(this.traceAgentActiveThread);
        sb.append(", traceAgentDataSource=").append(this.traceAgentDataSource);
        sb.append(", dataSourceTraceLimitSize=").append(this.dataSourceTraceLimitSize);
        sb.append(", deadlockMonitorEnable=").append(this.deadlockMonitorEnable);
        sb.append(", deadlockMonitorInterval=").append(this.deadlockMonitorInterval);
        sb.append(", callStackMaxDepth=").append(this.callStackMaxDepth);
        sb.append(", jdbcSqlCacheSize=").append(this.jdbcSqlCacheSize);
        sb.append(", traceSqlBindValue=").append(this.traceSqlBindValue);
        sb.append(", maxSqlBindValueSize=").append(this.maxSqlBindValueSize);
        sb.append(", samplingEnable=").append(this.samplingEnable);
        sb.append(", samplingRate=").append(this.samplingRate);
        sb.append(", samplingNewThroughput=").append(this.samplingNewThroughput);
        sb.append(", samplingContinueThroughput=").append(this.samplingContinueThroughput);
        sb.append(", ioBufferingEnable=").append(this.ioBufferingEnable);
        sb.append(", ioBufferingBufferSize=").append(this.ioBufferingBufferSize);
        sb.append(", profileJvmVendorName='").append(this.profileJvmVendorName).append('\'');
        sb.append(", profileOsName='").append(this.profileOsName).append('\'');
        sb.append(", profileJvmStatCollectIntervalMs=").append(this.profileJvmStatCollectIntervalMs);
        sb.append(", profileJvmStatBatchSendCount=").append(this.profileJvmStatBatchSendCount);
        sb.append(", profilerJvmStatCollectDetailedMetrics=").append(this.profilerJvmStatCollectDetailedMetrics);
        sb.append(", profilableClassFilter=").append(this.profilableClassFilter);
        sb.append(", DEFAULT_AGENT_INFO_SEND_RETRY_INTERVAL=").append(300000L);
        sb.append(", agentInfoSendRetryInterval=").append(this.agentInfoSendRetryInterval);
        sb.append(", applicationServerType='").append(this.applicationServerType).append('\'');
        sb.append(", applicationTypeDetectOrder=").append(this.applicationTypeDetectOrder);
        sb.append(", disabledPlugins=").append(this.disabledPlugins);
        sb.append(", propagateInterceptorException=").append(this.propagateInterceptorException);
        sb.append(", supportLambdaExpressions=").append(this.supportLambdaExpressions);
        sb.append(", proxyHttpHeaderEnable=").append(this.proxyHttpHeaderEnable);
        sb.append(", httpStatusCodeErrors=").append(this.httpStatusCodeErrors);
        sb.append(", injectionModuleFactoryClazzName='").append(this.injectionModuleFactoryClazzName).append('\'');
        sb.append(", applicationNamespace='").append(this.applicationNamespace).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private class PlaceHolderResolver
    implements ValueResolver {
        private PlaceHolderResolver() {
        }

        @Override
        public String resolve(String value, Properties properties) {
            if (value == null) {
                return null;
            }
            return DefaultProfilerConfig.this.propertyPlaceholderHelper.replacePlaceholders(value, properties);
        }
    }

    private static class BypassResolver
    implements ValueResolver {
        public static final ValueResolver RESOLVER = new BypassResolver();

        private BypassResolver() {
        }

        @Override
        public String resolve(String value, Properties properties) {
            return value;
        }
    }

    public static interface ValueResolver {
        public String resolve(String var1, Properties var2);
    }
}

