/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class UnLockUpdateCheckProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("UnLockUpdateCheckProcessor");

    @Override
    public String process(ProcessContext context) throws ProcessException {
        RandomAccessFile agentUpdateFileAccessor = (RandomAccessFile)context.remove("context_lock_file");
        FileLock lock = (FileLock)context.remove("context_lock");
        if (lock != null) {
            try {
                this.logger.info("UnLock update directory");
                lock.release();
            }
            catch (Exception ex) {
                this.logger.warn("Failed to unlock update directory", ex);
            }
        }
        if (agentUpdateFileAccessor != null) {
            try {
                agentUpdateFileAccessor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "next";
    }
}

