/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class LockUpdateCheckProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("LockUpdateCheckProcessor");
    public static final String FLOW_NO_UPDATE = "no-update";
    public static final String CONTEXT_LOCK_FILE = "context_lock_file";
    public static final String CONTEXT_LOCK = "context_lock";

    @Override
    public String process(ProcessContext context) throws ProcessException {
        File updateDir = (File)context.get("Agent-Update-Directory");
        if (updateDir == null || !updateDir.exists()) {
            this.logger.info("This directory({}) does not exist, start agent directly", updateDir.getAbsolutePath());
            return FLOW_NO_UPDATE;
        }
        File updateLock = new File(updateDir, "tapm.update.lock");
        RandomAccessFile agentUpdateFileAccessor = null;
        FileChannel channel = null;
        FileLock lock = null;
        try {
            agentUpdateFileAccessor = new RandomAccessFile(updateLock, "rw");
            channel = agentUpdateFileAccessor.getChannel();
            this.logger.info("Lock update directory {}", updateDir.getAbsolutePath());
            lock = channel.lock();
            context.put(CONTEXT_LOCK_FILE, agentUpdateFileAccessor);
            context.put(CONTEXT_LOCK, lock);
            return "next";
        }
        catch (Exception e) {
            this.logger.warn("Unable to get lock for " + updateDir.getAbsolutePath(), e);
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (agentUpdateFileAccessor != null) {
                try {
                    agentUpdateFileAccessor.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return "failed";
        }
    }
}

