/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow;

import java.util.HashMap;
import java.util.Map;

public class FlowItem {
    private Map<String, FlowItem> nexts = new HashMap<String, FlowItem>();
    private String processName;

    private FlowItem(String processName) {
        this.processName = processName;
    }

    private FlowItem(String processName, Map<String, FlowItem> nexts) {
        this.processName = processName;
        this.nexts.putAll(nexts);
    }

    public FlowItem next(String flowName) {
        return this.nexts.get(flowName);
    }

    public String getProcessorName() {
        return this.processName;
    }

    public static Builder newBuilderForProcessorName(String name) {
        return new Builder(name);
    }

    public void putNext(String flowName, FlowItem flowItem) {
        this.nexts.put(flowName, flowItem);
    }

    public static class BuilderForProcess {
        private Builder b;
        private String name;

        public BuilderForProcess(Builder b, String name) {
            this.b = b;
            this.name = name;
        }

        public Builder toProcessor(FlowItem item) {
            this.b.subItems.put(this.name, item);
            return this.b;
        }

        public Builder toProcessor(String nextName) {
            this.b.subItems.put(this.name, new FlowItem(nextName));
            return this.b;
        }
    }

    public static class Builder {
        private String name;
        private Map<String, FlowItem> subItems = new HashMap<String, FlowItem>();

        private Builder(String name) {
            this.name = name;
        }

        public BuilderForProcess on(String name) {
            return new BuilderForProcess(this, name);
        }

        public FlowItem build() {
            return new FlowItem(this.name, this.subItems);
        }
    }
}

