/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.kafka.field.accessor.RemoteAddressFieldAccessor;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerConfig;

public class ConsumerConstructorInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (throwable != null) {
            return;
        }
        if (!(target instanceof RemoteAddressFieldAccessor)) {
            return;
        }
        ConsumerConfig consumerConfig = this.getConsumerConfig(args);
        if (consumerConfig == null) {
            return;
        }
        String remoteAddress = this.getRemoteAddress(consumerConfig);
        ((RemoteAddressFieldAccessor)target)._$PINPOINT$_setRemoteAddress(remoteAddress);
    }

    private ConsumerConfig getConsumerConfig(Object[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return null;
        }
        if (args[0] instanceof ConsumerConfig) {
            return (ConsumerConfig)args[0];
        }
        return null;
    }

    private String getRemoteAddress(ConsumerConfig consumerConfig) {
        List serverList = consumerConfig.getList("bootstrap.servers");
        String remoteAddress = "Unknown";
        if (CollectionUtils.nullSafeSize((Collection)serverList) == 1) {
            remoteAddress = (String)serverList.get(0);
        } else if (CollectionUtils.nullSafeSize((Collection)serverList) > 1) {
            remoteAddress = serverList.toString();
        }
        return remoteAddress;
    }
}

