/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class HbasePluginConfig {
    private final boolean clientProfile;
    private final boolean adminProfile;
    private final boolean tableProfile;
    private final boolean paramsProfile;

    public HbasePluginConfig(ProfilerConfig config) {
        this.clientProfile = config.readBoolean("profiler.hbase.client.enable", true);
        this.adminProfile = config.readBoolean("profiler.hbase.client.admin.enable", true);
        this.tableProfile = config.readBoolean("profiler.hbase.client.table.enable", true);
        this.paramsProfile = config.readBoolean("profiler.hbase.client.params.enable", false);
    }

    public boolean isClientProfile() {
        return this.clientProfile;
    }

    public boolean isAdminProfile() {
        return this.adminProfile;
    }

    public boolean isTableProfile() {
        return this.tableProfile;
    }

    public boolean isParamsProfile() {
        return this.paramsProfile;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HbasePluginConfig [clientProfile=");
        builder.append(this.clientProfile);
        builder.append(", adminProfile=");
        builder.append(this.adminProfile);
        builder.append(", tableProfile=");
        builder.append(this.tableProfile);
        builder.append(", paramsProfile=");
        builder.append(this.paramsProfile);
        builder.append("]");
        return builder.toString();
    }
}

