/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.profiler.sender.PartitionedByteBufferLocator;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanStreamSendDataSerializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    ByteBuffer createStartBuffer(byte chunkCount) {
        ByteBuffer startBuffer = ByteBuffer.allocate(3);
        startBuffer.put((byte)-52);
        startBuffer.put((byte)16);
        startBuffer.put(chunkCount);
        startBuffer.flip();
        return startBuffer;
    }

    ByteBuffer createEndBuffer() {
        ByteBuffer endBuffer = ByteBuffer.allocate(1);
        endBuffer.put((byte)122);
        endBuffer.flip();
        return endBuffer;
    }

    public PartitionedByteBufferLocator serializeSpanStream(HeaderTBaseSerializer serializer, TSpan span) {
        PartitionedByteBufferLocator.Builder partitionedByteBufferLocatorBuilder = new PartitionedByteBufferLocator.Builder();
        List spanEventList = span.getSpanEventList();
        if (spanEventList != null) {
            for (TSpanEvent spanEvent : spanEventList) {
                int bufferStartIndex = serializer.getInterBufferSize();
                try {
                    byte[] buffer = serializer.continueSerialize((TBase)spanEvent);
                    int bufferEndIndex = serializer.getInterBufferSize();
                    partitionedByteBufferLocatorBuilder.addIndex(bufferStartIndex, bufferEndIndex);
                }
                catch (TException e) {
                    this.logger.warn("Serialize fail. value:{}.", (Object)spanEvent, (Object)e);
                    serializer.reset(bufferStartIndex);
                }
            }
        }
        TSpan copiedSpan = this.copySpanWithoutSpanEvent(span);
        try {
            int bufferStartIndex = serializer.getInterBufferSize();
            byte[] buffer = serializer.continueSerialize((TBase)copiedSpan);
            int bufferEndIndex = serializer.getInterBufferSize();
            partitionedByteBufferLocatorBuilder.addIndex(bufferStartIndex, bufferEndIndex);
            partitionedByteBufferLocatorBuilder.setBuffer(buffer);
            return partitionedByteBufferLocatorBuilder.build();
        }
        catch (TException e) {
            this.logger.warn("Serialize fail. value:{}.", (Object)copiedSpan, (Object)e);
            return null;
        }
    }

    private TSpan copySpanWithoutSpanEvent(TSpan span) {
        TSpan copiedSpan = span.deepCopy();
        copiedSpan.setSpanEventList(Collections.emptyList());
        return copiedSpan;
    }

    public PartitionedByteBufferLocator serializeSpanChunkStream(HeaderTBaseSerializer serializer, TSpanChunk spanChunk) {
        PartitionedByteBufferLocator.Builder partitionedByteBufferLocatorBuilder = new PartitionedByteBufferLocator.Builder();
        List spanEventList = spanChunk.getSpanEventList();
        if (spanEventList != null) {
            for (TSpanEvent spanEvent : spanEventList) {
                int bufferStartIndex = serializer.getInterBufferSize();
                try {
                    byte[] buffer = serializer.continueSerialize((TBase)spanEvent);
                    int bufferEndIndex = serializer.getInterBufferSize();
                    partitionedByteBufferLocatorBuilder.addIndex(bufferStartIndex, bufferEndIndex);
                }
                catch (TException e) {
                    this.logger.warn("Serialize fail. value:{}.", (Object)spanEvent, (Object)e);
                    serializer.reset(bufferStartIndex);
                }
            }
        }
        TSpanChunk copiedSpanChunk = this.copySpanChunkWithoutSpanEvent(spanChunk);
        try {
            int bufferStartIndex = serializer.getInterBufferSize();
            byte[] buffer = serializer.continueSerialize((TBase)copiedSpanChunk);
            int bufferEndIndex = serializer.getInterBufferSize();
            partitionedByteBufferLocatorBuilder.addIndex(bufferStartIndex, bufferEndIndex);
            partitionedByteBufferLocatorBuilder.setBuffer(buffer);
            return partitionedByteBufferLocatorBuilder.build();
        }
        catch (TException e) {
            this.logger.warn("Serialize fail. value:{}.", (Object)copiedSpanChunk, (Object)e);
            return null;
        }
    }

    private TSpanChunk copySpanChunkWithoutSpanEvent(TSpanChunk spanChunk) {
        TSpanChunk copiedSpanChunk = spanChunk.deepCopy();
        copiedSpanChunk.setSpanEventList(Collections.emptyList());
        return copiedSpanChunk;
    }
}

