/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.profiler.objectfactory.ArgumentsResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<?> type;
    private final ArgumentsResolver argumentsResolver;
    private Constructor<?> resolvedConstructor;
    private Object[] resolvedArguments;
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            int p2;
            int p1 = o1.getParameterTypes().length;
            return p1 < (p2 = o2.getParameterTypes().length) ? 1 : (p1 == p2 ? 0 : -1);
        }
    };

    public ConstructorResolver(Class<?> type, ArgumentsResolver argumentsResolver) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        this.type = type;
        this.argumentsResolver = argumentsResolver;
    }

    public boolean resolve() {
        Constructor<?>[] constructors = this.type.getConstructors();
        Arrays.sort(constructors, CONSTRUCTOR_COMPARATOR);
        for (Constructor<?> constructor : constructors) {
            Annotation[][] parameterAnnotations;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] resolvedArguments = this.argumentsResolver.resolve(parameterTypes, parameterAnnotations = constructor.getParameterAnnotations());
            if (resolvedArguments == null) continue;
            this.resolvedConstructor = constructor;
            this.resolvedArguments = resolvedArguments;
            return true;
        }
        if (this.logger.isWarnEnabled()) {
            this.resolveFailLog(this.type);
        }
        return false;
    }

    public Constructor<?> getResolvedConstructor() {
        return this.resolvedConstructor;
    }

    public Object[] getResolvedArguments() {
        return this.resolvedArguments;
    }

    private void resolveFailLog(Class<?> type) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            Object[] parameterTypes = constructor.getParameterTypes();
            this.logger.warn("Constructor resolve fail. class:{} {}", (Object)type.getName(), (Object)Arrays.toString(parameterTypes));
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object parameterClass = parameterTypes[i];
                ClassLoader parameterClassLoader = type.getClassLoader();
                this.logger.warn("index:{} {} cl:{}", new Object[]{i, parameterClass, parameterClassLoader});
            }
        }
    }
}

