/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.memory;

import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.MemoryMetricSnapshot;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class DefaultMemoryMetric
implements MemoryMetric {
    private MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    @Override
    public MemoryMetricSnapshot getSnapshot() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        long heapMax = heapMemoryUsage.getMax();
        long heapUsed = heapMemoryUsage.getUsed();
        long nonHeapMax = nonHeapMemoryUsage.getMax();
        long nonHeapUsed = nonHeapMemoryUsage.getUsed();
        return new MemoryMetricSnapshot(heapMax, heapUsed, nonHeapMax, nonHeapUsed);
    }

    public String toString() {
        return "Default memory metric";
    }
}

