/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.metric.datasource;

import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorRegistryService;
import com.navercorp.pinpoint.profiler.context.monitor.DataSourceMonitorWrapper;
import com.navercorp.pinpoint.profiler.context.monitor.JdbcUrlParsingService;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSource;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetric;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultDataSourceMetric
implements DataSourceMetric {
    private final DataSourceMonitorRegistryService dataSourceMonitorRegistryService;
    private final JdbcUrlParsingService jdbcUrlParsingService;

    public DefaultDataSourceMetric(DataSourceMonitorRegistryService dataSourceMonitorRegistryService, JdbcUrlParsingService jdbcUrlParsingService) {
        if (dataSourceMonitorRegistryService == null) {
            throw new NullPointerException("dataSourceMonitorRegistryService must not be null");
        }
        if (jdbcUrlParsingService == null) {
            throw new NullPointerException("jdbcUrlParsingService must not be null");
        }
        this.dataSourceMonitorRegistryService = dataSourceMonitorRegistryService;
        this.jdbcUrlParsingService = jdbcUrlParsingService;
    }

    @Override
    public List<DataSource> dataSourceList() {
        List<DataSourceMonitorWrapper> dataSourceMonitorList = this.dataSourceMonitorRegistryService.getPluginMonitorWrapperList();
        if (CollectionUtils.isEmpty(dataSourceMonitorList)) {
            return Collections.emptyList();
        }
        ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>(dataSourceMonitorList.size());
        for (DataSourceMonitorWrapper dataSourceMonitor : dataSourceMonitorList) {
            DataSource dataSource = this.collectDataSource(dataSourceMonitor);
            dataSourceList.add(dataSource);
        }
        return dataSourceList;
    }

    public String toString() {
        return "Default DataSourceMetric";
    }

    private DataSource collectDataSource(DataSourceMonitorWrapper dataSourceMonitor) {
        int activeConnectionSize;
        DataSource dataSource = new DataSource(dataSourceMonitor.getId());
        dataSource.setServiceTypeCode(dataSourceMonitor.getServiceType().getCode());
        String jdbcUrl = dataSourceMonitor.getUrl();
        if (jdbcUrl != null) {
            dataSource.setUrl(jdbcUrl);
            DatabaseInfo databaseInfo = this.jdbcUrlParsingService.getDatabaseInfo(jdbcUrl);
            if (databaseInfo != null) {
                dataSource.setDatabaseName(databaseInfo.getDatabaseId());
            }
        }
        if ((activeConnectionSize = dataSourceMonitor.getActiveConnectionSize()) != 0) {
            dataSource.setActiveConnectionSize(activeConnectionSize);
        }
        dataSource.setMaxConnectionSize(dataSourceMonitor.getMaxConnectionSize());
        return dataSource;
    }
}

