/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.ClassNameMatcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.Matcher;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.MultiClassNameMatcher;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.transformer.BaseTransformerRegistry;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.ClassFileTransformer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultTransformerRegistry
implements BaseTransformerRegistry {
    private final Map<String, ClassFileTransformer> registry = new HashMap<String, ClassFileTransformer>(512);

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer) {
        return this.findTransformer(classLoader, classInternalName, classFileBuffer, null);
    }

    @Override
    public ClassFileTransformer findTransformer(ClassLoader classLoader, String classInternalName, byte[] classFileBuffer, InternalClassMetadata classMetadata) {
        return this.registry.get(classInternalName);
    }

    @Override
    public void addTransformer(Matcher matcher, ClassFileTransformer transformer) {
        if (matcher instanceof ClassNameMatcher) {
            ClassNameMatcher classNameMatcher = (ClassNameMatcher)matcher;
            String className = classNameMatcher.getClassName();
            this.addModifier0(transformer, className);
        } else if (matcher instanceof MultiClassNameMatcher) {
            MultiClassNameMatcher classNameMatcher = (MultiClassNameMatcher)matcher;
            List classNameList = classNameMatcher.getClassNames();
            for (String className : classNameList) {
                this.addModifier0(transformer, className);
            }
        } else {
            throw new IllegalArgumentException("unsupported matcher :" + matcher);
        }
    }

    private void addModifier0(ClassFileTransformer transformer, String className) {
        String classInternalName = JavaAssistUtils.javaNameToJvmName(className);
        ClassFileTransformer old = this.registry.put(classInternalName, transformer);
        if (old != null) {
            throw new IllegalStateException("Transformer already exist. className:" + classInternalName + " new:" + transformer.getClass() + " old:" + old.getClass());
        }
    }
}

