/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.config.InstrumentMatcherCacheConfig;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AnnotationInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.ClassInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.InterfaceInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.PackageInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.SuperClassInternalNameMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.AndMatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.MatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.NotMatcherOperator;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.OrMatcherOperator;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadataReader;
import com.navercorp.pinpoint.profiler.instrument.transformer.HierarchyCaches;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransformerMatcher
implements TransformerMatcher {
    private static final String OBJECT_CLASS_INTERNAL_NAME = "java/lang/Object";
    private static final String ANNOTATION_PACKAGE_INTERNAL_NAME = "java/lang/annotation";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HierarchyCaches interfaceCaches;
    private HierarchyCaches annotationCaches;
    private HierarchyCaches superCaches;

    public DefaultTransformerMatcher(InstrumentMatcherCacheConfig cacheConfig) {
        this.interfaceCaches = new HierarchyCaches(cacheConfig.getInterfaceCacheSize(), cacheConfig.getInterfaceCacheEntrySize());
        this.annotationCaches = new HierarchyCaches(cacheConfig.getAnnotationCacheSize(), cacheConfig.getAnnotationCacheEntrySize());
        this.superCaches = new HierarchyCaches(cacheConfig.getSuperCacheSize(), cacheConfig.getSuperCacheEntrySize());
    }

    @Override
    public boolean match(ClassLoader classLoader, MatcherOperand operand, InternalClassMetadata classMetadata) {
        if (operand.isOperator()) {
            return this.traversal(classLoader, operand, classMetadata);
        }
        if (operand instanceof ClassInternalNameMatcherOperand) {
            return this.matchClass((ClassInternalNameMatcherOperand)operand, classMetadata);
        }
        if (operand instanceof PackageInternalNameMatcherOperand) {
            return this.matchPackage((PackageInternalNameMatcherOperand)operand, classMetadata);
        }
        if (operand instanceof InterfaceInternalNameMatcherOperand) {
            return this.matchInterface(classLoader, (InterfaceInternalNameMatcherOperand)operand, classMetadata);
        }
        if (operand instanceof AnnotationInternalNameMatcherOperand) {
            return this.matchAnnotation(classLoader, (AnnotationInternalNameMatcherOperand)operand, classMetadata);
        }
        if (operand instanceof SuperClassInternalNameMatcherOperand) {
            return this.matchSuper(classLoader, (SuperClassInternalNameMatcherOperand)operand, classMetadata);
        }
        throw new IllegalArgumentException("unknown operand. operand=" + operand);
    }

    boolean matchClass(ClassInternalNameMatcherOperand operand, InternalClassMetadata classMetadata) {
        if (classMetadata == null) {
            return false;
        }
        if (classMetadata.isInterface() || classMetadata.isAnnotation()) {
            return false;
        }
        return operand.match(classMetadata.getClassInternalName());
    }

    boolean matchPackage(PackageInternalNameMatcherOperand operand, InternalClassMetadata classMetadata) {
        if (classMetadata == null) {
            return false;
        }
        if (classMetadata.isInterface() || classMetadata.isAnnotation()) {
            return false;
        }
        return operand.match(classMetadata.getClassInternalName());
    }

    boolean matchAnnotation(ClassLoader classLoader, AnnotationInternalNameMatcherOperand operand, InternalClassMetadata classMetadata) {
        if (classMetadata == null) {
            return false;
        }
        for (String annotationInternalName : classMetadata.getAnnotationInternalNames()) {
            if (!operand.match(annotationInternalName)) continue;
            if (this.annotationCaches.isActive() && classMetadata.isAnnotation()) {
                this.annotationCaches.put(operand.getAnnotationInternalName(), classMetadata.getClassInternalName());
            }
            return true;
        }
        if (!operand.isConsiderMetaAnnotation()) {
            return false;
        }
        for (String annotationInternalName : classMetadata.getAnnotationInternalNames()) {
            if (annotationInternalName.startsWith(ANNOTATION_PACKAGE_INTERNAL_NAME)) continue;
            if (this.annotationCaches.isActive() && this.annotationCaches.get(operand.getAnnotationInternalName(), annotationInternalName)) {
                if (classMetadata.isAnnotation()) {
                    this.annotationCaches.put(operand.getAnnotationInternalName(), classMetadata.getClassInternalName());
                }
                return true;
            }
            if (!this.matchAnnotation(classLoader, operand, this.readClassMetadata(classLoader, annotationInternalName))) continue;
            return true;
        }
        return false;
    }

    boolean matchInterface(ClassLoader classLoader, InterfaceInternalNameMatcherOperand operand, InternalClassMetadata classMetadata) {
        if (classMetadata == null || classMetadata.getClassInternalName().equals(OBJECT_CLASS_INTERNAL_NAME)) {
            return false;
        }
        for (String interfaceInternalName : classMetadata.getInterfaceInternalNames()) {
            if (!operand.match(interfaceInternalName)) continue;
            if (this.interfaceCaches.isActive() && !classMetadata.isSynthetic() && !classMetadata.isInnerClass()) {
                this.interfaceCaches.put(operand.getInterfaceInternalName(), classMetadata.getClassInternalName());
            }
            return true;
        }
        if (!operand.isConsiderHierarchy()) {
            return false;
        }
        for (String interfaceInternalName : classMetadata.getInterfaceInternalNames()) {
            if (!operand.isJavaPackage() && interfaceInternalName.startsWith("java/")) continue;
            if (this.interfaceCaches.isActive() && this.interfaceCaches.get(operand.getInterfaceInternalName(), interfaceInternalName)) {
                if (!classMetadata.isSynthetic() && !classMetadata.isInnerClass()) {
                    this.interfaceCaches.put(operand.getInterfaceInternalName(), classMetadata.getClassInternalName());
                }
                return true;
            }
            if (!this.matchInterface(classLoader, operand, this.readClassMetadata(classLoader, interfaceInternalName))) continue;
            return true;
        }
        if (this.interfaceCaches.isActive() && this.interfaceCaches.get(operand.getInterfaceInternalName(), classMetadata.getSuperClassInternalName())) {
            if (!classMetadata.isSynthetic() && !classMetadata.isInnerClass()) {
                this.interfaceCaches.put(operand.getInterfaceInternalName(), classMetadata.getClassInternalName());
            }
            return true;
        }
        return this.matchInterface(classLoader, operand, this.readClassMetadata(classLoader, classMetadata.getSuperClassInternalName()));
    }

    boolean matchSuper(ClassLoader classLoader, SuperClassInternalNameMatcherOperand operand, InternalClassMetadata classMetadata) {
        if (classMetadata == null || classMetadata.getSuperClassInternalName() == null || classMetadata.getSuperClassInternalName().equals(OBJECT_CLASS_INTERNAL_NAME)) {
            return false;
        }
        if (operand.match(classMetadata.getSuperClassInternalName())) {
            if (this.superCaches.isActive() && !classMetadata.isSynthetic() && !classMetadata.isInnerClass()) {
                this.superCaches.put(operand.getSuperClassInternalNames(), classMetadata.getClassInternalName());
            }
            return true;
        }
        if (!operand.isConsiderHierarchy()) {
            return false;
        }
        if (classMetadata.getSuperClassInternalName() == null || classMetadata.getSuperClassInternalName().equals(OBJECT_CLASS_INTERNAL_NAME)) {
            return false;
        }
        if (!operand.isJavaPackage() && classMetadata.getSuperClassInternalName().startsWith("java/")) {
            return false;
        }
        if (this.superCaches.isActive() && this.superCaches.get(operand.getSuperClassInternalNames(), classMetadata.getSuperClassInternalName())) {
            if (!classMetadata.isSynthetic() && !classMetadata.isInnerClass()) {
                this.superCaches.put(operand.getSuperClassInternalNames(), classMetadata.getClassInternalName());
            }
            return true;
        }
        return this.matchSuper(classLoader, operand, this.readClassMetadata(classLoader, classMetadata.getSuperClassInternalName()));
    }

    private InternalClassMetadata readClassMetadata(ClassLoader classLoader, String classInternalName) {
        if (classInternalName == null) {
            return null;
        }
        try {
            return InternalClassMetadataReader.readInternalClassMetadata(classLoader, classInternalName);
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Failed to read metadata of class. classLoader={}, internalName={}", new Object[]{classLoader, classInternalName, e});
            }
            return null;
        }
    }

    boolean traversal(ClassLoader classLoader, MatcherOperand operand, InternalClassMetadata classMetadata) {
        if (operand instanceof NotMatcherOperator) {
            NotMatcherOperator operator = (NotMatcherOperator)operand;
            if (operator.getRightOperand() == null) {
                throw new IllegalArgumentException("invalid operator - not found right operand. operator=" + operator);
            }
            MatcherOperand rightOperand = operator.getRightOperand();
            return !this.match(classLoader, rightOperand, classMetadata);
        }
        MatcherOperator operator = (MatcherOperator)operand;
        if (operator.getLeftOperand() == null) {
            throw new IllegalArgumentException("invalid operator - not found left operand. operator=" + operator);
        }
        MatcherOperand leftOperand = operator.getLeftOperand();
        if (operator.getRightOperand() == null) {
            throw new IllegalArgumentException("invalid operator - not found right operand. operator=" + operator);
        }
        MatcherOperand rightOperand = operator.getRightOperand();
        MatcherOperand firstOperand = leftOperand;
        MatcherOperand secondOperand = rightOperand;
        if (leftOperand.getExecutionCost() > rightOperand.getExecutionCost()) {
            firstOperand = rightOperand;
            secondOperand = leftOperand;
        }
        if (operand instanceof OrMatcherOperator) {
            if (this.match(classLoader, firstOperand, classMetadata)) {
                return true;
            }
            return this.match(classLoader, secondOperand, classMetadata);
        }
        if (operand instanceof AndMatcherOperator) {
            if (this.match(classLoader, firstOperand, classMetadata)) {
                return this.match(classLoader, secondOperand, classMetadata);
            }
            return false;
        }
        throw new IllegalArgumentException("unknown operator. operator=" + operator);
    }
}

